/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.datagen;

import java.util.Optional;
import net.edu.resprouted.block.custom.decorative.CabinetBlock;
import net.edu.resprouted.block.enums.CabinetType;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class ModCabinetTemplateModels {
    public static final class_4945 CABINET = class_4945.method_27043((String)"cabinet");
    public static final class_4945 FRONT = class_4945.method_27043((String)"front");
    public static final class_4945 SIDE = class_4945.method_27043((String)"side");
    public static final class_4942 TEMPLATE_CABINET = new class_4942(Optional.of(class_2960.method_60655((String)"minecraft", (String)"block/orientable")), Optional.empty(), new class_4945[]{FRONT, SIDE, class_4945.field_23015});
    public static final class_4942 TEMPLATE_CABINET_BOTTOM = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_bottom")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_BOTTOM_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_bottom_left")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_BOTTOM_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_bottom_open")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_BOTTOM_OPEN_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_bottom_open_left")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_TOP = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_top")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_TOP_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_top_left")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_TOP_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_top_open")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});
    public static final class_4942 TEMPLATE_CABINET_TOP_OPEN_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"resprouted", (String)"block/template_cabinet_top_open_left")), Optional.empty(), new class_4945[]{CABINET, class_4945.field_23012});

    public static void registerCabinetModels(class_4910 blockStateModelGenerator, class_2248 cabinetBlock, String woodType) {
        String blockName = ModCabinetTemplateModels.getBlockName(cabinetBlock);
        CabinetModels models = ModCabinetTemplateModels.generateCabinetModels(blockStateModelGenerator, woodType, blockName);
        ModCabinetTemplateModels.createCabinetBlockState(blockStateModelGenerator, cabinetBlock, models);
        ModCabinetTemplateModels.registerCabinetItemModel(blockStateModelGenerator, cabinetBlock, models.singleClosed);
    }

    private static CabinetModels generateCabinetModels(class_4910 generator, String woodType, String blockName) {
        CabinetModels models = new CabinetModels();
        String basePath = "block/" + blockName;
        class_4944 singleClosedTextures = new class_4944().method_25868(FRONT, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_front"))).method_25868(SIDE, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side"))).method_25868(class_4945.field_23015, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.singleClosed = TEMPLATE_CABINET.method_25852(class_2960.method_60655((String)"resprouted", (String)basePath), singleClosedTextures, generator.field_22831);
        class_4944 singleClosedLeftTextures = new class_4944().method_25868(FRONT, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_front_left"))).method_25868(SIDE, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side"))).method_25868(class_4945.field_23015, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.singleClosedLeft = TEMPLATE_CABINET.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_left")), singleClosedLeftTextures, generator.field_22831);
        class_4944 singleOpenTextures = new class_4944().method_25868(FRONT, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_front_open"))).method_25868(SIDE, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side"))).method_25868(class_4945.field_23015, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.singleOpen = TEMPLATE_CABINET.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_open")), singleOpenTextures, generator.field_22831);
        class_4944 singleOpenLeftTextures = new class_4944().method_25868(FRONT, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_front_open_left"))).method_25868(SIDE, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side"))).method_25868(class_4945.field_23015, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.singleOpenLeft = TEMPLATE_CABINET.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_open_left")), singleOpenLeftTextures, generator.field_22831);
        class_4944 topTextures = new class_4944().method_25868(CABINET, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_double_cabinet"))).method_25868(class_4945.field_23012, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.topClosed = TEMPLATE_CABINET_TOP.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_top")), topTextures, generator.field_22831);
        models.topClosedLeft = TEMPLATE_CABINET_TOP_LEFT.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_top_left")), topTextures, generator.field_22831);
        models.topOpen = TEMPLATE_CABINET_TOP_OPEN.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_top_open")), topTextures, generator.field_22831);
        models.topOpenLeft = TEMPLATE_CABINET_TOP_OPEN_LEFT.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_top_open_left")), topTextures, generator.field_22831);
        class_4944 bottomTextures = new class_4944().method_25868(CABINET, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_double_cabinet"))).method_25868(class_4945.field_23012, class_2960.method_60655((String)"resprouted", (String)("block/" + woodType + "_cabinet_side")));
        models.bottomClosed = TEMPLATE_CABINET_BOTTOM.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_bottom")), bottomTextures, generator.field_22831);
        models.bottomClosedLeft = TEMPLATE_CABINET_BOTTOM_LEFT.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_bottom_left")), bottomTextures, generator.field_22831);
        models.bottomOpen = TEMPLATE_CABINET_BOTTOM_OPEN.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_bottom_open")), bottomTextures, generator.field_22831);
        models.bottomOpenLeft = TEMPLATE_CABINET_BOTTOM_OPEN_LEFT.method_25852(class_2960.method_60655((String)"resprouted", (String)(basePath + "_bottom_open_left")), bottomTextures, generator.field_22831);
        return models;
    }

    private static void createCabinetBlockState(class_4910 generator, class_2248 cabinet, CabinetModels models) {
        generator.field_22830.accept(class_4925.method_25769((class_2248)cabinet).method_25775(class_4926.method_25786((class_2769)class_2741.field_12481, CabinetBlock.CABINET_TYPE, (class_2769)CabinetBlock.OPEN, CabinetBlock.HINGE).method_35886((facing, cabinetType, open, hinge) -> {
            class_4935 variant = class_4935.method_25824();
            class_2960 model = ModCabinetTemplateModels.getModelForState(models, cabinetType, open, hinge);
            variant.method_25828(class_4936.field_22887, (Object)model);
            class_4936.class_4937 rotation = switch (facing) {
                case class_2350.field_11034 -> class_4936.class_4937.field_22891;
                case class_2350.field_11035 -> class_4936.class_4937.field_22892;
                case class_2350.field_11039 -> class_4936.class_4937.field_22893;
                default -> class_4936.class_4937.field_22890;
            };
            variant.method_25828(class_4936.field_22886, (Object)rotation);
            return variant;
        })));
    }

    private static class_2960 getModelForState(CabinetModels models, CabinetType cabinetType, boolean open, class_2750 hinge) {
        boolean isLeft = hinge == class_2750.field_12588;
        return switch (cabinetType) {
            default -> throw new MatchException(null, null);
            case CabinetType.SINGLE -> {
                if (open) {
                    if (isLeft) {
                        yield models.singleOpenLeft;
                    }
                    yield models.singleOpen;
                }
                if (isLeft) {
                    yield models.singleClosedLeft;
                }
                yield models.singleClosed;
            }
            case CabinetType.TOP -> {
                if (open) {
                    if (isLeft) {
                        yield models.topOpenLeft;
                    }
                    yield models.topOpen;
                }
                if (isLeft) {
                    yield models.topClosedLeft;
                }
                yield models.topClosed;
            }
            case CabinetType.BOTTOM -> {
                if (open) {
                    if (isLeft) {
                        yield models.bottomOpenLeft;
                    }
                    yield models.bottomOpen;
                }
                yield isLeft ? models.bottomClosedLeft : models.bottomClosed;
            }
        };
    }

    private static void registerCabinetItemModel(class_4910 generator, class_2248 cabinet, class_2960 baseModel) {
        generator.method_25623(cabinet, baseModel);
    }

    private static String getBlockName(class_2248 block) {
        class_2960 blockId = block.method_40142().method_40237().method_29177();
        return blockId.method_12832();
    }

    private static class CabinetModels {
        class_2960 singleClosed;
        class_2960 singleClosedLeft;
        class_2960 singleOpen;
        class_2960 singleOpenLeft;
        class_2960 topClosed;
        class_2960 topClosedLeft;
        class_2960 topOpen;
        class_2960 topOpenLeft;
        class_2960 bottomClosed;
        class_2960 bottomClosedLeft;
        class_2960 bottomOpen;
        class_2960 bottomOpenLeft;

        private CabinetModels() {
        }
    }
}

