/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.edu.resprouted.effect.ModEffects;
import net.edu.resprouted.item.custom.BoozeBottleItem;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class BoozeEffects {
    public static void applyAleEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(2, 4.0f * quality);
            int duration = 1200 + (int)(10800.0f * quality);
            player.method_6092(new class_1293(ModEffects.FULL_STOMACH, duration));
        } else {
            int duration = (int)(6000.0f * (1.0f - quality));
            player.method_6092(new class_1293(class_1294.field_5903, duration));
            player.method_6092(new class_1293(class_1294.field_5916, duration));
        }
    }

    public static void applyIronWineEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        class_1937 world = context.world();
        float quality = context.quality();
        if (world.field_9236) {
            return;
        }
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            float a = 10.0f * Math.max((quality - 0.5f) * 2.0f, 0.0f);
            float currentAbs = player.method_6067();
            float newAbs = Math.min(currentAbs + a, 20.0f);
            class_1324 maxAb = player.method_5996(class_5134.field_45124);
            if (maxAb != null && maxAb.method_6201() < (double)newAbs) {
                maxAb.method_6192((double)newAbs);
            }
            player.method_6073(newAbs);
        } else {
            int duration = (int)(6000.0 * Math.max((double)(1.0f - quality), 0.25));
            float damage = 10.0f * Math.max(Math.abs(quality - 0.5f) + 0.1f, 0.25f);
            player.method_5643(player.method_48923().method_48831(), damage);
            player.method_6092(new class_1293(class_1294.field_5916, duration));
        }
    }

    public static void applyCiderEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            int duration = 1200 + (int)(10800.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
            player.method_6092(new class_1293(ModEffects.MAGIC_RESISTANCE, duration));
        } else {
            int poisonDuration = (int)(1200.0f * Math.max(1.0f - quality, 0.25f));
            player.method_6092(new class_1293(class_1294.field_5899, poisonDuration));
            int nauseaDuration = (int)(6000.0f * Math.max(1.0f - quality, 0.25f));
            player.method_6092(new class_1293(class_1294.field_5916, nauseaDuration));
        }
    }

    public static void applyMeadEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            int duration = 1200 + (int)(6000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
            player.method_6092(new class_1293(ModEffects.WITHER_WARD, duration));
        } else {
            int witherDuration = (int)(800.0 * Math.max((double)(1.0f - quality), 0.25));
            player.method_6092(new class_1293(class_1294.field_5920, witherDuration));
            int nauseaDuration = (int)(6000.0 * Math.max((double)(1.0f - quality), 0.25));
            player.method_6092(new class_1293(class_1294.field_5916, nauseaDuration));
        }
    }

    public static void applySweetBerryWineEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            for (class_1293 effect : player.method_6026()) {
                if (((class_1291)effect.method_5579().comp_349()).method_18792() != class_4081.field_18271 || effect.method_5578() >= 2) continue;
                player.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578() + 1, effect.method_5591(), effect.method_5581(), effect.method_5592()));
            }
        } else {
            for (class_1293 effect : player.method_6026()) {
                if (((class_1291)effect.method_5579().comp_349()).method_18792() != class_4081.field_18271) continue;
                if (effect.method_5578() > 0) {
                    player.method_6016(effect.method_5579());
                    player.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578() - 1, effect.method_5591(), effect.method_5581(), effect.method_5592()));
                    continue;
                }
                if (effect.method_5578() != 0) continue;
                player.method_6016(effect.method_5579());
            }
            int nauseaDuration = (int)(6000.0f * Math.max(1.0f - quality, 0.25f));
            player.method_6092(new class_1293(class_1294.field_5916, nauseaDuration));
        }
    }

    public static void applyWineEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            int durationIncrease = 600 + (int)(2400.0f * ((quality - 0.5f) * 2.0f));
            for (class_1293 effect : player.method_6026()) {
                if (((class_1291)effect.method_5579().comp_349()).method_18792() != class_4081.field_18271 || effect.method_5584() >= 12000) continue;
                int newDuration = Math.min(effect.method_5584() + durationIncrease, 12000);
                player.method_6092(new class_1293(effect.method_5579(), newDuration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
            }
        } else {
            int durationDecrease = (int)(2400.0 * Math.abs((double)quality - 0.6));
            for (class_1293 effect : player.method_6026()) {
                if (((class_1291)effect.method_5579().comp_349()).method_18792() != class_4081.field_18271) continue;
                int newDuration = effect.method_5584() - durationDecrease;
                player.method_6016(effect.method_5579());
                if (newDuration <= 0) continue;
                player.method_6092(new class_1293(effect.method_5579(), newDuration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
            }
            int nauseaDuration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
            player.method_6092(new class_1293(class_1294.field_5916, nauseaDuration));
        }
    }

    public static void applyAmbrosiaEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        if (quality >= 0.5f) {
            int duration;
            player.method_7344().method_7585(2, 2.0f * quality);
            if (quality > 0.99f) {
                duration = -1;
                player.method_6016(ModEffects.UNDYING);
            } else {
                duration = 6000 + (int)(18000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
            }
            player.method_6092(new class_1293(ModEffects.UNDYING, duration, 0, false, false));
        } else {
            player.method_5643(player.method_48923().method_48831(), Float.MAX_VALUE);
        }
    }

    public static void applyGlowBerryWineEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        class_1937 world = player.method_37908();
        float quality = context.quality();
        if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 2.0f * quality);
            int baseDuration = 1200;
            int bonusDuration = (int)(4800.0f * quality);
            if (!world.field_9236) {
                class_2338 playerPos = player.method_24515();
                double radius = 30.0;
                class_238 box = new class_238(playerPos).method_1014(radius);
                List nearbyEntities = world.method_18467(class_1309.class, box);
                for (class_1309 entity : nearbyEntities) {
                    if (!entity.method_5805() || entity.method_31481() || !playerPos.method_19769((class_2374)entity.method_19538(), radius) || entity == player) continue;
                    entity.method_6092(new class_1293(class_1294.field_5912, baseDuration + bonusDuration, 0, false, false, true));
                }
            }
        } else {
            player.method_7344().method_7585(1, 0.5f * quality);
            int negativeDuration = (int)(6000.0f * (1.0f - quality));
            player.method_6092(new class_1293(class_1294.field_5919, negativeDuration, 0, false, true, true));
            player.method_6092(new class_1293(class_1294.field_5916, negativeDuration / 2, 0, false, true, true));
            if (quality <= 0.2f) {
                player.method_6092(new class_1293(class_1294.field_38092, negativeDuration / 2, 0, false, true, true));
            }
        }
    }

    public static void applyRumEffects(BoozeBottleItem.BoozeConsumptionContext context) {
        class_1657 player = context.player();
        float quality = context.quality();
        boolean hasTipsy = player.method_6059(ModEffects.TIPSY);
        if (quality >= 0.75f) {
            player.method_7344().method_7585(2, 3.0f * quality);
            HashMap<class_6880, class_1293> savedEffects = new HashMap<class_6880, class_1293>();
            if (hasTipsy) {
                class_1293 blindness;
                class_1293 class_12932;
                class_1293 class_12933;
                class_1293 tipsyEffect = player.method_6112(ModEffects.TIPSY);
                if (tipsyEffect != null) {
                    savedEffects.put(tipsyEffect.method_5579(), new class_1293(tipsyEffect));
                }
                if ((class_12933 = player.method_6112(class_1294.field_5916)) != null) {
                    savedEffects.put(class_12933.method_5579(), new class_1293(class_12933));
                }
                if ((class_12932 = player.method_6112(class_1294.field_5909)) != null) {
                    savedEffects.put(class_12932.method_5579(), new class_1293(class_12932));
                }
                if ((blindness = player.method_6112(class_1294.field_5919)) != null) {
                    savedEffects.put(blindness.method_5579(), new class_1293(blindness));
                }
            }
            ArrayList<class_6880> effectsToRemove = new ArrayList<class_6880>();
            for (class_1293 class_12934 : player.method_6026()) {
                if (((class_1291)class_12934.method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
                effectsToRemove.add(class_12934.method_5579());
            }
            for (class_6880 class_68802 : effectsToRemove) {
                player.method_6016(class_68802);
            }
            for (class_1293 class_12935 : savedEffects.values()) {
                player.method_6092(class_12935);
            }
        } else if (quality >= 0.5f) {
            player.method_7344().method_7585(1, 1.5f * quality);
            ArrayList<class_6880> harmfulEffects = new ArrayList<class_6880>();
            for (class_1293 class_12936 : player.method_6026()) {
                if (((class_1291)class_12936.method_5579().comp_349()).method_18792() != class_4081.field_18272 || hasTipsy && BoozeEffects.isTipsyRelatedEffect((class_6880<class_1291>)class_12936.method_5579())) continue;
                harmfulEffects.add(class_12936.method_5579());
            }
            if (!harmfulEffects.isEmpty()) {
                class_6880 randomEffect = (class_6880)harmfulEffects.get(player.method_59922().method_43048(harmfulEffects.size()));
                player.method_6016(randomEffect);
            }
        } else if (quality >= 0.2f) {
            int duration = (int)(6000.0f * (1.0f - quality));
            player.method_6092(new class_1293(class_1294.field_5911, duration, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5901, duration / 2, 0, false, false, true));
        } else {
            ArrayList<class_6880> positiveEffectsToRemove = new ArrayList<class_6880>();
            for (class_1293 class_12937 : player.method_6026()) {
                if (((class_1291)class_12937.method_5579().comp_349()).method_18792() != class_4081.field_18271) continue;
                positiveEffectsToRemove.add(class_12937.method_5579());
            }
            for (class_6880 class_68803 : positiveEffectsToRemove) {
                player.method_6016(class_68803);
            }
            int duration = (int)(8000.0f * (1.0f - quality));
            player.method_6092(new class_1293(class_1294.field_5911, duration, 1, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5901, duration, 1, false, false, true));
        }
    }

    private static boolean isTipsyRelatedEffect(class_6880<class_1291> effect) {
        class_1291 statusEffect = (class_1291)effect.comp_349();
        return statusEffect == ModEffects.TIPSY || statusEffect == class_1294.field_5916 || statusEffect == class_1294.field_5909 || statusEffect == class_1294.field_5919;
    }
}

