/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.event;

import net.edu.resprouted.Resprouted;
import net.edu.resprouted.block.ModBlocks;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.edu.resprouted.effect.ModEffects;
import net.edu.resprouted.item.custom.StakeCropSeedItem;
import net.edu.resprouted.util.misc.GrassSeedsRegistry;
import net.edu.resprouted.util.recipe.RecipeUtils;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ModCommonEvents {
    public static void registerEvents() {
        Resprouted.LOGGER.info("Registering Common Events for resprouted");
        ServerLivingEntityEvents.ALLOW_DEATH.register(ModCommonEvents::onAllowDeath);
        UseItemCallback.EVENT.register(ModCommonEvents::onWaterBottleUse);
        AttackEntityCallback.EVENT.register(ModCommonEvents::onAttackEntity);
        EntitySleepEvents.ALLOW_SLEEPING.register(ModCommonEvents::onPlayerSleep);
        PlayerBlockBreakEvents.AFTER.register(ModCommonEvents::onBlockBreak);
    }

    private static void onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (world.method_8608()) {
            return;
        }
        if (!Resprouted.COMMON_CONFIG.world.isEnableSeedDrops() || player.method_7337()) {
            return;
        }
        if (state.method_27852(class_2246.field_10479) || state.method_27852(class_2246.field_10214)) {
            float seedChance = (float)Resprouted.COMMON_CONFIG.world.getSeedsDropRate() / 100.0f;
            for (StakeCropSeedItem seed : GrassSeedsRegistry.getRegisteredSeeds()) {
                if (!(world.method_8409().method_43057() < seedChance)) continue;
                ModCommonEvents.dropItem(world, pos, new class_1799((class_1935)seed));
            }
        }
        if (state.method_27852(class_2246.field_10597)) {
            boolean shouldDrop = false;
            if (!Resprouted.COMMON_CONFIG.world.isGrapeDropNeedsTool()) {
                shouldDrop = true;
            } else {
                class_1799 stack = player.method_6047();
                if (!stack.method_7960()) {
                    class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                    String itemName = itemId.toString();
                    if (Resprouted.COMMON_CONFIG.world.getGrapeSeedsToolWhitelist().contains(itemName)) {
                        shouldDrop = true;
                    }
                }
            }
            float seedChance = (float)Resprouted.COMMON_CONFIG.world.getSeedsDropRate() / 100.0f;
            if (shouldDrop && world.method_8409().method_43057() < seedChance) {
                ModCommonEvents.dropItem(world, pos, new class_1799((class_1935)ModBlocks.GRAPE_STEM));
            }
        }
    }

    private static void dropItem(class_1937 world, class_2338 pos, class_1799 stack) {
        class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack);
        itemEntity.method_6988();
        world.method_8649((class_1297)itemEntity);
    }

    @Nullable
    private static class_1657.class_1658 onPlayerSleep(class_1657 player, class_2338 sleepingPos) {
        if (player.method_6059(ModEffects.FULL_METAL)) {
            return class_1657.class_1658.field_7531;
        }
        return null;
    }

    private static class_1269 onAttackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        class_1293 currentEffect;
        if (world.method_8608() || !(entity instanceof class_1309)) {
            return class_1269.field_5811;
        }
        class_1309 target = (class_1309)entity;
        class_1799 weapon = player.method_5998(hand);
        if (weapon.method_57826(ModDataComponentTypes.VANTA_OILED) && (currentEffect = (class_1293)weapon.method_57824(ModDataComponentTypes.VANTA_OILED)) != null) {
            int hitDuration;
            if (!target.method_33190()) {
                return class_1269.field_5811;
            }
            int totalDuration = currentEffect.method_5584();
            int amplifier = currentEffect.method_5578();
            class_6880 effectType = currentEffect.method_5579();
            if (totalDuration < 1 || amplifier < 0) {
                weapon.method_57381(ModDataComponentTypes.VANTA_OILED);
                return class_1269.field_5811;
            }
            boolean isInstant = ((class_1291)effectType.comp_349()).method_5561();
            int effectDuration = hitDuration = isInstant ? 1 : RecipeUtils.getNextVantaHitDuration(totalDuration);
            class_1293 activeEffect = target.method_6112(effectType);
            if (activeEffect != null) {
                int activeDur = activeEffect.method_5584();
                if (activeDur <= 0) {
                    target.method_6016(effectType);
                } else if (activeEffect.method_5578() == amplifier) {
                    effectDuration += activeDur;
                } else if (activeEffect.method_5578() > amplifier) {
                    effectDuration = 0;
                }
            }
            if (effectDuration > 0) {
                if (isInstant) {
                    ((class_1291)effectType.comp_349()).method_5564((class_1297)player, (class_1297)player, target, amplifier, 1.0);
                } else {
                    target.method_37222(new class_1293(effectType, effectDuration, amplifier, currentEffect.method_5591(), currentEffect.method_5581(), currentEffect.method_5592()), (class_1297)player);
                }
            }
            int newDuration = totalDuration - hitDuration;
            class_1293 newVantaEffect = null;
            if (newDuration > 0) {
                newVantaEffect = new class_1293(effectType, newDuration, amplifier, currentEffect.method_5591(), currentEffect.method_5581(), currentEffect.method_5592());
            }
            if (weapon.method_7947() > 1) {
                class_1799 remainingStack = weapon.method_7971(weapon.method_7947() - 1);
                weapon.method_57379(ModDataComponentTypes.VANTA_OILED, (Object)newVantaEffect);
                if (!player.method_31548().method_7394(remainingStack)) {
                    player.method_7328(remainingStack, false);
                }
            } else if (newVantaEffect == null) {
                weapon.method_57381(ModDataComponentTypes.VANTA_OILED);
            } else {
                weapon.method_57379(ModDataComponentTypes.VANTA_OILED, newVantaEffect);
            }
        }
        return class_1269.field_5811;
    }

    private static class_1271<class_1799> onWaterBottleUse(class_1657 player, class_1937 world, class_1268 hand) {
        class_1293 effect;
        class_1844 potionContents;
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == class_1802.field_8574 && (potionContents = (class_1844)stack.method_57824(class_9334.field_49651)) != null && potionContents.method_57401(class_1847.field_8991) && (effect = player.method_6112(ModEffects.TIPSY)) != null && !world.method_8608()) {
            class_5819 random = player.method_59922();
            int duration = effect.method_5584();
            int amplifier = effect.method_5578();
            if (random.method_43057() < 0.1f) {
                --amplifier;
            } else {
                duration -= random.method_43048(800) + 200;
            }
            player.method_6016(ModEffects.TIPSY);
            if (amplifier >= 0 && duration > 0) {
                player.method_6092(new class_1293(ModEffects.TIPSY, duration, amplifier, false, false));
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    private static boolean onAllowDeath(class_1309 entity, class_1282 source, float damageAmount) {
        if (source.method_5530()) {
            return true;
        }
        if (!(entity instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)entity;
        class_1293 effect = player.method_6112(ModEffects.UNDYING);
        if (effect == null) {
            return true;
        }
        player.method_6016(ModEffects.UNDYING);
        player.method_6033(1.0f);
        player.method_6012();
        player.method_6092(new class_1293(class_1294.field_5924, 900, 1));
        player.method_6092(new class_1293(class_1294.field_5898, 100, 1));
        player.method_6092(new class_1293(class_1294.field_5918, 800, 0));
        player.method_37908().method_8421((class_1297)player, (byte)35);
        if (effect.method_5578() > 0) {
            player.method_6092(new class_1293(ModEffects.UNDYING, effect.method_5584(), effect.method_5578() - 1, effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
        return false;
    }
}

