/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.edu.resprouted.effect.ModEffects;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.edu.resprouted.util.misc.TextUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BoozeBottleItem
extends class_1792 {
    private final class_3611 fluidType;
    private static final Map<class_3611, BoozeBottleItem> FLUID_TO_BOTTLE = new HashMap<class_3611, BoozeBottleItem>();
    private final Consumer<BoozeConsumptionContext> effectConsumer;
    protected float inebriationChance = 0.5f;

    public BoozeBottleItem(class_3611 fluidType, class_1792.class_1793 settings, Consumer<BoozeConsumptionContext> effectConsumer) {
        super(settings);
        this.fluidType = fluidType;
        this.effectConsumer = effectConsumer;
        FLUID_TO_BOTTLE.put(fluidType, this);
    }

    public BoozeBottleItem(class_3611 fluidType, class_1792.class_1793 settings) {
        this(fluidType, settings, context -> {});
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 playerEntity;
        super.method_7861(stack, world, user);
        class_1657 class_16572 = playerEntity = user instanceof class_1657 ? (class_1657)user : null;
        if (!world.method_8608() && playerEntity != null) {
            float quality = BoozeBottleItem.getQuality(stack);
            this.effectConsumer.accept(new BoozeConsumptionContext(world, playerEntity, quality));
            this.inebriate(world, playerEntity, quality);
            if (!playerEntity.method_56992()) {
                stack.method_7934(1);
                class_1799 glassBottle = new class_1799((class_1935)class_1802.field_8469);
                if (stack.method_7960()) {
                    return glassBottle;
                }
                if (!playerEntity.method_31548().method_7394(glassBottle)) {
                    playerEntity.method_7328(glassBottle, false);
                }
            }
        }
        user.method_32876((class_6880)class_5712.field_28734);
        return stack;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    public class_3414 method_21830() {
        return class_3417.field_20615;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 32;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        float quality = BoozeBottleItem.getQuality(stack);
        tooltip.add(TextUtils.addQualityText(quality));
    }

    public static float getQuality(class_1799 stack) {
        Float quality = (Float)stack.method_57824(ModDataComponentTypes.FLUID_QUALITY);
        return quality != null ? quality.floatValue() : 0.0f;
    }

    public static void setQuality(class_1799 stack, float quality) {
        stack.method_57379(ModDataComponentTypes.FLUID_QUALITY, (Object)Float.valueOf(Math.max(0.0f, Math.min(1.0f, quality))));
    }

    public static class_1799 fromFluidVariant(FluidVariant variant) {
        class_3611 fluid = variant.getFluid();
        BoozeBottleItem bottleItem = FLUID_TO_BOTTLE.get(fluid);
        if (bottleItem != null) {
            float quality = FluidUtils.getQuality(variant);
            class_1799 bottle = new class_1799((class_1935)bottleItem);
            BoozeBottleItem.setQuality(bottle, quality);
            return bottle;
        }
        return class_1799.field_8037;
    }

    public FluidVariant toFluidVariant(class_1799 bottle) {
        float quality = BoozeBottleItem.getQuality(bottle);
        return FluidUtils.withQuality(this.fluidType, quality);
    }

    public static BoozeBottleItem getBottleForFluid(class_3611 fluid) {
        return FLUID_TO_BOTTLE.get(fluid);
    }

    public static class_3611 getFluidFromBottle(class_1799 bottleStack) {
        class_1792 item = bottleStack.method_7909();
        for (class_3611 fluid : class_7923.field_41173) {
            BoozeBottleItem bottleItem = BoozeBottleItem.getBottleForFluid(fluid);
            if (bottleItem != item) continue;
            return fluid;
        }
        return class_3612.field_15906;
    }

    public BoozeBottleItem setInebriationChance(float chance) {
        this.inebriationChance = chance;
        return this;
    }

    protected void inebriate(class_1937 world, class_1657 player, float quality) {
        int duration = quality >= 0.5f ? (int)(12000.0f * Math.max(1.0f - Math.abs(quality - 0.75f), 0.5f)) : (int)(12000.0f * Math.max(1.0f - quality * 0.5f, 0.5f));
        float inebriationChanceMod = Math.max(Math.min(1.0f - Math.abs(0.67f * (quality - 0.75f)), 1.0f), 0.0f);
        class_1293 tipsyEffect = player.method_6112(ModEffects.TIPSY);
        if (world.field_9229.method_43057() < this.inebriationChance * inebriationChanceMod) {
            if (tipsyEffect == null) {
                player.method_6092(new class_1293(ModEffects.TIPSY, duration, 0, false, false));
            } else if (tipsyEffect.method_5578() < 3) {
                player.method_6092(new class_1293(ModEffects.TIPSY, Math.max(duration, tipsyEffect.method_5584()), tipsyEffect.method_5578() + 1, false, false));
            }
        }
    }

    public record BoozeConsumptionContext(class_1937 world, class_1657 player, float quality) {
    }
}

