/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.recipe.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.edu.resprouted.block.custom.alchemy.AdvancedCondenserBlock;
import net.edu.resprouted.block.entity.custom.alchemy.AdvancedCondenserBlockEntity;
import net.edu.resprouted.recipe.Input.AdvancedCondenserRecipeInput;
import net.edu.resprouted.recipe.ModRecipes;
import net.edu.resprouted.util.misc.ElixirUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AdvancedCondenserRecipe(List<class_1856> ingredients, Optional<class_1856> modifier, class_6880<class_1291> effect, int duration, int amplifier) implements class_1860<AdvancedCondenserRecipeInput>
{
    public boolean matches(AdvancedCondenserRecipeInput input, class_1937 world) {
        class_2586 class_25862;
        if (world.method_8608()) {
            return false;
        }
        if (this.ingredients.size() < 2 || this.ingredients.size() > 3) {
            return false;
        }
        List<class_1799> actualInputs = Stream.of(input.inputA(), input.inputB(), input.inputC()).filter(stack -> !stack.method_7960()).toList();
        if (this.ingredients.size() != actualInputs.size()) {
            return false;
        }
        ArrayList<class_1856> ingredientsCopy = new ArrayList<class_1856>(this.ingredients);
        for (class_1799 stack2 : actualInputs) {
            boolean matched = ingredientsCopy.removeIf(ing -> ing.method_8093(stack2));
            if (matched) continue;
            return false;
        }
        boolean hasFuelOrBurning = false;
        boolean hasRetorts = false;
        class_2586 class_25863 = world.method_8321(input.pos());
        if (class_25863 instanceof AdvancedCondenserBlockEntity) {
            AdvancedCondenserBlockEntity be = (AdvancedCondenserBlockEntity)class_25863;
            hasFuelOrBurning = be.isBurning() || !input.fuel().method_7960();
            class_2680 blockState = world.method_8320(input.pos());
            class_25862 = blockState.method_26204();
            if (class_25862 instanceof AdvancedCondenserBlock) {
                AdvancedCondenserBlock advcondenser = (AdvancedCondenserBlock)class_25862;
                hasRetorts = advcondenser.hasRetorts(world, input.pos(), blockState);
            }
        }
        boolean hasBottle = input.bottle().method_31574(class_1802.field_8469);
        boolean hasFluid = false;
        class_25862 = world.method_8321(input.pos());
        if (class_25862 instanceof AdvancedCondenserBlockEntity) {
            AdvancedCondenserBlockEntity be = (AdvancedCondenserBlockEntity)class_25862;
            hasFluid = be.hasFluid();
        }
        if (this.modifier.isPresent() ? !this.modifier.get().method_8093(input.modifier()) : !input.modifier().method_7960()) {
            return false;
        }
        return hasFuelOrBurning && hasBottle && hasFluid && hasRetorts;
    }

    public class_1799 craft(AdvancedCondenserRecipeInput input, class_7225.class_7874 lookup) {
        return ElixirUtils.createElixir(this.effect, this.duration, this.amplifier);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return ElixirUtils.createElixir(this.effect, this.duration, this.amplifier);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.ADVANCED_CONDENSER_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.ADVANCED_CONDENSER_TYPE;
    }

    public static class Serializer
    implements class_1865<AdvancedCondenserRecipe> {
        public static final MapCodec<AdvancedCondenserRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_1856.field_46096.listOf().fieldOf("ingredients").forGetter(AdvancedCondenserRecipe::ingredients), (App)class_1856.field_46096.optionalFieldOf("modifier").forGetter(AdvancedCondenserRecipe::modifier), (App)class_1291.field_51933.fieldOf("effect").forGetter(AdvancedCondenserRecipe::effect), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(AdvancedCondenserRecipe::duration), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(AdvancedCondenserRecipe::amplifier)).apply((Applicative)inst, AdvancedCondenserRecipe::new));
        public static final class_9139<class_9129, AdvancedCondenserRecipe> STREAM_CODEC = class_9139.method_56906((class_9139)class_1856.field_48355.method_56433(class_9135.method_56363()), AdvancedCondenserRecipe::ingredients, (class_9139)class_9135.method_56382((class_9139)class_1856.field_48355), AdvancedCondenserRecipe::modifier, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), AdvancedCondenserRecipe::effect, (class_9139)class_9135.field_48550, AdvancedCondenserRecipe::duration, (class_9139)class_9135.field_48550, AdvancedCondenserRecipe::amplifier, AdvancedCondenserRecipe::new);

        public MapCodec<AdvancedCondenserRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, AdvancedCondenserRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

