/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.recipe.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.edu.resprouted.block.custom.alchemy.AdvancedCondenserBlock;
import net.edu.resprouted.block.custom.alchemy.BasicCondenserBlock;
import net.edu.resprouted.block.entity.custom.alchemy.AdvancedCondenserBlockEntity;
import net.edu.resprouted.block.entity.custom.alchemy.BasicCondenserBlockEntity;
import net.edu.resprouted.recipe.Input.BasicCondenserRecipeInput;
import net.edu.resprouted.recipe.ModRecipes;
import net.edu.resprouted.util.misc.ElixirUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BasicCondenserRecipe(List<class_1856> ingredients, class_6880<class_1291> effect, int duration, int amplifier) implements class_1860<BasicCondenserRecipeInput>
{
    public boolean matches(BasicCondenserRecipeInput input, class_1937 world) {
        if (world.method_8608()) {
            return false;
        }
        if (this.ingredients.isEmpty() || this.ingredients.size() > 2) {
            return false;
        }
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        if (!input.inputA().method_7960()) {
            inputs.add(input.inputA());
        }
        if (!input.inputB().method_7960()) {
            inputs.add(input.inputB());
        }
        if (inputs.size() != this.ingredients.size()) {
            return false;
        }
        ArrayList<class_1856> ingredientsCopy = new ArrayList<class_1856>(this.ingredients);
        for (class_1799 stack : inputs) {
            boolean matched = ingredientsCopy.removeIf(ing -> ing.method_8093(stack));
            if (matched) continue;
            return false;
        }
        boolean hasFuelOrBurning = false;
        boolean hasRetorts = false;
        boolean hasFluid = false;
        boolean hasBottle = input.bottle().method_31574(class_1802.field_8469);
        class_2586 class_25862 = world.method_8321(input.pos());
        if (class_25862 instanceof BasicCondenserBlockEntity) {
            BasicCondenserBlockEntity be = (BasicCondenserBlockEntity)class_25862;
            hasFuelOrBurning = be.isBurning() || !input.fuel().method_7960();
            hasFluid = be.hasFluid();
            blockState = world.method_8320(input.pos());
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof BasicCondenserBlock) {
                BasicCondenserBlock condenserBlock = (BasicCondenserBlock)class_22482;
                hasRetorts = condenserBlock.hasRetorts(world, input.pos(), (class_2680)blockState);
            }
        } else {
            blockState = world.method_8321(input.pos());
            if (blockState instanceof AdvancedCondenserBlockEntity) {
                AdvancedCondenserBlockEntity be = (AdvancedCondenserBlockEntity)blockState;
                hasFuelOrBurning = be.isBurning() || !input.fuel().method_7960();
                hasFluid = be.hasFluid();
                blockState = world.method_8320(input.pos());
                class_2248 class_22483 = blockState.method_26204();
                if (class_22483 instanceof AdvancedCondenserBlock) {
                    AdvancedCondenserBlock condenserBlock = (AdvancedCondenserBlock)class_22483;
                    hasRetorts = condenserBlock.hasRetorts(world, input.pos(), (class_2680)blockState);
                }
            }
        }
        return hasFuelOrBurning && hasBottle && hasFluid && hasRetorts;
    }

    public class_1799 craft(BasicCondenserRecipeInput input, class_7225.class_7874 lookup) {
        return ElixirUtils.createElixir(this.effect, this.duration, this.amplifier);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return ElixirUtils.createElixir(this.effect, this.duration, this.amplifier);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.CONDENSER_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.CONDENSER_TYPE;
    }

    public static class Serializer
    implements class_1865<BasicCondenserRecipe> {
        public static final MapCodec<BasicCondenserRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_1856.field_46096.listOf().fieldOf("ingredients").forGetter(BasicCondenserRecipe::ingredients), (App)class_1291.field_51933.fieldOf("effect").forGetter(BasicCondenserRecipe::effect), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(BasicCondenserRecipe::duration), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(BasicCondenserRecipe::amplifier)).apply((Applicative)inst, BasicCondenserRecipe::new));
        public static final class_9139<class_9129, BasicCondenserRecipe> STREAM_CODEC = class_9139.method_56905((class_9139)class_1856.field_48355.method_56433(class_9135.method_56363()), BasicCondenserRecipe::ingredients, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), BasicCondenserRecipe::effect, (class_9139)class_9135.field_48550, BasicCondenserRecipe::duration, (class_9139)class_9135.field_48550, BasicCondenserRecipe::amplifier, BasicCondenserRecipe::new);

        public MapCodec<BasicCondenserRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BasicCondenserRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

