/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.recipe.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.edu.resprouted.Resprouted;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3611;
import net.minecraft.class_5819;

public record BrewingBarrelRecipe(class_3611 outputFluid, class_3611 inputFluid) {
    public static final List<BrewingBarrelRecipe> RECIPES = new ArrayList<BrewingBarrelRecipe>();

    public boolean matches(FluidVariant input, long inputAmount, FluidVariant aux, long auxAmount) {
        boolean inputMatches;
        if (this.inputFluid == null || input == null || input.isBlank() || inputAmount <= 0L) {
            return false;
        }
        boolean bl = inputMatches = input.getFluid() == this.inputFluid;
        if (aux != null && !aux.isBlank() && auxAmount > 0L) {
            boolean auxMatches = aux.getFluid() == this.outputFluid;
            return inputMatches && auxMatches;
        }
        return inputMatches;
    }

    public FluidVariant getResult(FluidVariant input, long inputAmount, FluidVariant aux, long auxAmount, class_5819 random) {
        if (aux == null || aux.isBlank() || auxAmount <= 0L || !this.matches(input, inputAmount, aux, auxAmount)) {
            return this.getResult(input, inputAmount, random);
        }
        if (this.matches(input, inputAmount, aux, auxAmount) && this.outputFluid != null) {
            if (FluidUtils.hasQuality(aux)) {
                float auxQuality = FluidUtils.getQuality(aux);
                int minChange = BrewingBarrelRecipe.getMinBrewQualityChange();
                int maxChange = BrewingBarrelRecipe.getMaxBrewQualityChange();
                if (maxChange < minChange) {
                    maxChange = minChange;
                }
                int brewQualityChange = random.method_43048(maxChange - minChange + 1) + minChange;
                float quality = Math.max(Math.min((float)(brewQualityChange + (int)(100.0f * auxQuality)) / 100.0f, 1.0f), 0.0f);
                return FluidUtils.withQuality(this.outputFluid, quality);
            }
            return FluidUtils.withQuality(this.outputFluid, this.getBaseQuality(random));
        }
        return null;
    }

    public FluidVariant getResult(FluidVariant input, long inputAmount, class_5819 random) {
        if (this.matches(input, inputAmount, null, 0L) && this.outputFluid != null) {
            return FluidUtils.withQuality(this.outputFluid, this.getBaseQuality(random));
        }
        return null;
    }

    private float getBaseQuality(class_5819 random) {
        return (float)(5 + random.method_43048(71)) / 100.0f;
    }

    public static void register(BrewingBarrelRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static int getMinBrewQualityChange() {
        return Resprouted.COMMON_CONFIG.brewing.getMinBrewQualityChange();
    }

    public static int getMaxBrewQualityChange() {
        return Resprouted.COMMON_CONFIG.brewing.getMaxBrewQualityChange();
    }

    public static Optional<BrewingBarrelRecipe> findMatchingRecipe(FluidVariant input, long inputAmount, FluidVariant auxiliary, long auxAmount) {
        return RECIPES.stream().filter(recipe -> recipe.matches(input, inputAmount, auxiliary, auxAmount)).findFirst();
    }

    public static List<BrewingBarrelRecipe> getRecipes() {
        return new ArrayList<BrewingBarrelRecipe>(RECIPES);
    }
}

