/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.recipe.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.edu.resprouted.recipe.Input.CrushingTubRecipeInput;
import net.edu.resprouted.recipe.ModRecipes;
import net.edu.resprouted.recipe.helper.RecipeOutput;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record CrushingTubRecipe(class_1856 inputItem, List<RecipeOutput> outputItems, FluidVariant fluidOutput, long fluidAmount, @Nullable class_2960 crushSoundId) implements class_1860<CrushingTubRecipeInput>
{
    public CrushingTubRecipe(class_1856 inputItem, List<RecipeOutput> outputItems, FluidVariant fluidOutput, long fluidAmount, @Nullable class_2960 crushSoundId) {
        if (outputItems.size() > 4) {
            throw new IllegalArgumentException("Cannot have more than 4 output items");
        }
    }

    public boolean matches(CrushingTubRecipeInput input, class_1937 world) {
        if (world.method_8608()) {
            return false;
        }
        return this.inputItem.method_8093(input.method_59984(0));
    }

    public class_1799 craft(CrushingTubRecipeInput input, class_7225.class_7874 lookup) {
        return this.outputItems.isEmpty() ? class_1799.field_8037 : this.outputItems.getFirst().stack().method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.outputItems.isEmpty() ? class_1799.field_8037 : this.outputItems.getFirst().stack();
    }

    public class_1865<?> method_8119() {
        return ModRecipes.CRUSHING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.CRUSHING_TYPE;
    }

    public class_3414 getCrushSound() {
        if (this.crushSoundId != null) {
            return (class_3414)class_7923.field_41172.method_10223(this.crushSoundId);
        }
        return class_3417.field_14560;
    }

    public static class CrushingTubRecipeSerializer
    implements class_1865<CrushingTubRecipe> {
        private static final Codec<List<RecipeOutput>> OUTPUT_CODEC = Codec.either(RecipeOutput.CODEC, (Codec)RecipeOutput.CODEC.listOf(1, 4)).xmap(either -> (List)either.map(List::of, list -> list), list -> list.size() == 1 ? Either.left((Object)((RecipeOutput)list.getFirst())) : Either.right((Object)list));
        public static final MapCodec<CrushingTubRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_1856.field_46096.fieldOf("input_item").forGetter(CrushingTubRecipe::inputItem), (App)OUTPUT_CODEC.optionalFieldOf("output_item", List.of()).forGetter(CrushingTubRecipe::outputItems), (App)FluidVariant.CODEC.optionalFieldOf("fluid_variant", (Object)FluidVariant.blank()).forGetter(CrushingTubRecipe::fluidOutput), (App)Codec.LONG.optionalFieldOf("amount", (Object)0L).xmap(FluidUtils::convertMbToDroplets, droplets -> droplets).forGetter(CrushingTubRecipe::fluidAmount), (App)class_2960.field_25139.optionalFieldOf("crush_sound").forGetter(r -> Optional.ofNullable(r.crushSoundId))).apply((Applicative)inst, (input, outputs, fluid, amount, soundId) -> new CrushingTubRecipe((class_1856)input, (List<RecipeOutput>)outputs, (FluidVariant)fluid, (long)amount, soundId.orElse(null))));
        public static final class_9139<class_9129, CrushingTubRecipe> STREAM_CODEC = class_9139.method_56437((buf, recipe) -> {
            class_1856.field_48355.encode(buf, (Object)recipe.inputItem());
            buf.method_10804(recipe.outputItems().size());
            for (RecipeOutput output : recipe.outputItems()) {
                RecipeOutput.PACKET_CODEC.encode(buf, (Object)output);
            }
            FluidVariant.PACKET_CODEC.encode(buf, (Object)recipe.fluidOutput());
            buf.method_10791(recipe.fluidAmount());
            buf.method_52964(recipe.crushSoundId() != null);
            if (recipe.crushSoundId() != null) {
                buf.method_10812(recipe.crushSoundId());
            }
        }, buf -> {
            class_1856 in = (class_1856)class_1856.field_48355.decode(buf);
            int outputCount = buf.method_10816();
            ArrayList<RecipeOutput> outputs = new ArrayList<RecipeOutput>(outputCount);
            for (int i = 0; i < outputCount; ++i) {
                outputs.add((RecipeOutput)RecipeOutput.PACKET_CODEC.decode(buf));
            }
            FluidVariant fluid = (FluidVariant)FluidVariant.PACKET_CODEC.decode(buf);
            long amt = buf.method_10792();
            boolean hasCrushSound = buf.readBoolean();
            class_2960 crushSound = hasCrushSound ? buf.method_10810() : null;
            return new CrushingTubRecipe(in, outputs, fluid, amt, crushSound);
        });

        public MapCodec<CrushingTubRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CrushingTubRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

