/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.edu.resprouted.fluid.data.FluidItemMapping;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class FluidItemLoader
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 ID = class_2960.method_60655((String)"resprouted", (String)"fluid_items");
    private static final List<FluidItemMapping> ENTRIES = new ArrayList<FluidItemMapping>();

    public static List<FluidItemMapping> getEntries() {
        return ENTRIES;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        ENTRIES.clear();
        String folder = "fluid_items";
        Map resources = manager.method_14488(folder, path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    Codec<FluidItemMapping> codec = FluidItemMapping.CODEC;
                    DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    result.resultOrPartial(error -> System.err.println("[Resprouted] Error parsing fluid item " + String.valueOf(id) + ": " + error)).ifPresent(ENTRIES::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                System.err.println("[Resprouted] Error loading fluid item " + String.valueOf(id) + ": " + String.valueOf(e));
            }
        }
        System.out.println("[Resprouted] Loaded " + ENTRIES.size() + " fluid item mappings.");
    }
}

