/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.edu.resprouted.util.misc.TextUtils;
import net.edu.resprouted.util.render.RenderUtils;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4068;
import net.minecraft.class_638;
import net.minecraft.class_8021;
import net.minecraft.class_9326;

public class FluidWidget
implements class_4068,
class_8021 {
    private final SingleFluidStorage fluidStorage;
    private final Supplier<class_2338> posSupplier;
    private final int width;
    private final int height;
    private int x;
    private int y;

    public FluidWidget(SingleFluidStorage fluidStorage, int x, int y, int width, int height, Supplier<class_2338> posSupplier) {
        this.fluidStorage = fluidStorage;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.posSupplier = posSupplier;
    }

    public static Builder builder(SingleFluidStorage fluidStorage) {
        return new Builder(fluidStorage);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        long fluidAmount = this.fluidStorage.getAmount();
        if (fluidAmount <= 0L) {
            return;
        }
        class_3611 fluid = ((FluidVariant)this.fluidStorage.variant).getFluid();
        long fluidCapacity = this.fluidStorage.getCapacity();
        int fluidHeight = Math.round((float)fluidAmount / (float)fluidCapacity * (float)this.height);
        FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (fluidRenderHandler == null) {
            return;
        }
        class_2338 pos = this.posSupplier.get();
        class_3610 fluidState = fluid.method_15785();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_1058 sprite = fluidRenderHandler.getFluidSprites((class_1920)world, pos, fluidState)[0];
        int tintColor = fluidRenderHandler.getFluidColor((class_1920)world, pos, fluidState);
        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(tintColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderUtils.renderTiledSprite(context, sprite, this.x, this.y + this.height - fluidHeight, this.width, fluidHeight, red, green, blue, 1.0f);
        if (FluidWidget.isPointWithinBounds(this.x, this.y, this.width, this.height, mouseX, mouseY)) {
            this.drawTooltip(context, mouseX, mouseY);
        }
    }

    public void method_46421(int x) {
        this.x = x;
    }

    public void method_46419(int y) {
        this.y = y;
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public int method_25368() {
        return this.width;
    }

    public int method_25364() {
        return this.height;
    }

    public void method_48206(Consumer<class_339> consumer) {
    }

    private static long getMb(long amount) {
        return (long)((float)FluidUtils.convertDropletsToMb(amount));
    }

    private static boolean isPointWithinBounds(int x, int y, int width, int height, int pointX, int pointY) {
        return pointX >= x && pointX <= x + width && pointY >= y && pointY <= y + height;
    }

    protected void drawTooltip(class_332 context, int mouseX, int mouseY) {
        class_3611 fluid = ((FluidVariant)this.fluidStorage.variant).getFluid();
        long fluidAmount = this.fluidStorage.getAmount();
        long fluidCapacity = this.fluidStorage.getCapacity();
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (fluid != null && fluidAmount > 0L) {
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            tooltipLines.add(class_2561.method_43471((String)fluid.method_15785().method_15759().method_26204().method_9539()));
            class_9326 components = ((FluidVariant)this.fluidStorage.variant).getComponents();
            if (components != null) {
                try {
                    Object t;
                    Optional qualityOpt = components.method_57845(ModDataComponentTypes.FLUID_QUALITY);
                    if (qualityOpt != null && qualityOpt.isPresent() && (t = qualityOpt.get()) instanceof Float) {
                        Float quality = (Float)t;
                        tooltipLines.add(TextUtils.addQualityText(quality.floatValue()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            tooltipLines.add(class_2561.method_43470((String)"%s/%s mB".formatted(FluidWidget.getMb(fluidAmount), FluidWidget.getMb(fluidCapacity))).method_27692(class_124.field_1080));
            context.method_51434(textRenderer, tooltipLines, mouseX, mouseY);
        }
    }

    public static class Builder {
        private final SingleFluidStorage fluidStorage;
        private Supplier<class_2338> posSupplier = () -> null;
        private int x;
        private int y;
        private int width;
        private int height;

        public Builder(SingleFluidStorage fluidStorage) {
            this.fluidStorage = fluidStorage;
        }

        public Builder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder posSupplier(Supplier<class_2338> posSupplier) {
            this.posSupplier = posSupplier;
            return this;
        }

        public FluidWidget build() {
            return new FluidWidget(this.fluidStorage, this.x, this.y, this.width, this.height, this.posSupplier);
        }
    }
}

