/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.util.block;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Function;
import net.edu.resprouted.block.interfaces.LuminousFluidStorage;
import net.edu.resprouted.util.fluid.FluidItemInteractionHelper;
import net.edu.resprouted.util.fluid.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_9062;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class BlockUtils {
    private static final class_6903<class_2520> TOOLTIP_OPS = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)class_7887.method_46817());
    private static final float FILL_WITH_RAIN_CHANCE = 0.05f;
    private static final float FILL_WITH_SNOW_CHANCE = 0.1f;

    public static void appendFluidTooltip(class_1799 stack, List<class_2561> tooltip) {
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49611);
        if (data == null) {
            return;
        }
        class_2487 fluidNbt = data.method_57461().method_10562("Fluid");
        if (fluidNbt.method_33133() || !fluidNbt.method_10545("variant") || !fluidNbt.method_10545("amount")) {
            return;
        }
        try {
            FluidVariant fluidVariant = FluidVariant.CODEC.parse(TOOLTIP_OPS, (Object)fluidNbt.method_10580("variant")).result().orElse(FluidVariant.blank());
            if (fluidVariant.isBlank()) {
                return;
            }
            class_2561 fluidName = FluidVariantAttributes.getName((FluidVariant)fluidVariant);
            long amount = FluidUtils.convertDropletsToMb(fluidNbt.method_10537("amount"));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.resprouted.fluid", (Object[])new Object[]{fluidName}).method_27692(class_124.field_1065));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.resprouted.amount", (Object[])new Object[]{amount}).method_27692(class_124.field_1065));
        }
        catch (Exception e) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.resprouted.fluid_error").method_27692(class_124.field_1061));
        }
    }

    public static void fillFromDripstone(class_2680 state, class_1937 world, class_2338 pos, class_3611 fluid, SingleFluidStorage storage, LuminousFluidStorage luminousBlock) {
        long currentAmount;
        long capacity;
        long spaceAvailable;
        if (fluid != class_3612.field_15910) {
            return;
        }
        if ((((FluidVariant)storage.getResource()).isOf((Object)class_3612.field_15910) || storage.isResourceBlank()) && (spaceAvailable = (capacity = storage.getCapacity()) - (currentAmount = storage.getAmount())) > 0L) {
            long amountToAdd = Math.min(20250L, spaceAvailable);
            try (Transaction tx = Transaction.openOuter();){
                storage.insert((TransferVariant)FluidVariant.of((class_3611)class_3612.field_15910), amountToAdd, (TransactionContext)tx);
                tx.commit();
                luminousBlock.updateBlockWithLight(world.method_8321(pos), world, pos, state);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                world.method_20290(1047, pos, 0);
            }
        }
    }

    public static void handlePrecipitation(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation, SingleFluidStorage storage, LuminousFluidStorage luminousBlock) {
        long currentAmount;
        long capacity;
        long available;
        if (!world.field_9236 && BlockUtils.canFillWithPrecipitation(world, precipitation) && (((FluidVariant)storage.getResource()).isOf((Object)class_3612.field_15910) || storage.isResourceBlank()) && (available = (capacity = storage.getCapacity()) - (currentAmount = storage.getAmount())) > 0L) {
            long amountToAdd = Math.min(20250L, available);
            try (Transaction tx = Transaction.openOuter();){
                storage.insert((TransferVariant)FluidVariant.of((class_3611)class_3612.field_15910), amountToAdd, (TransactionContext)tx);
                tx.commit();
                luminousBlock.updateBlockWithLight(world.method_8321(pos), world, pos, state);
            }
        }
    }

    public static boolean canFillWithPrecipitation(class_1937 world, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382) {
            return world.method_8409().method_43057() < 0.05f;
        }
        return precipitation == class_1959.class_1963.field_9383 && world.method_8409().method_43057() < 0.1f;
    }

    public static boolean canBeFilledByDripstone(class_3611 fluid) {
        return fluid == class_3612.field_15910;
    }

    public static boolean canStoreFluid(FluidVariant fluid) {
        if (fluid.isBlank()) {
            return true;
        }
        if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid)) {
            return false;
        }
        int temperature = FluidVariantAttributes.getTemperature((FluidVariant)fluid);
        return temperature <= 400;
    }

    public static class_9062 handleFluidInteraction(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, LuminousFluidStorage luminousBlock, class_2680 state) {
        class_9062 result;
        Storage fluidStorage = (Storage)FluidStorage.SIDED.find(world, pos, (Object)hit.method_17780());
        if (fluidStorage == null) {
            return class_9062.field_47733;
        }
        class_1799 stack = player.method_5998(hand);
        Storage handStorage = (Storage)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand).find(FluidStorage.ITEM);
        if (handStorage != null) {
            for (StorageView view : handStorage) {
                FluidVariant fluid = (FluidVariant)view.getResource();
                if (fluid.isBlank() || BlockUtils.canStoreFluid(fluid)) continue;
                if (!world.field_9236) {
                    if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid)) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.resprouted.cannot_store_gaseous").method_27692(class_124.field_1070), true);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.resprouted.cannot_store_too_hot").method_27692(class_124.field_1070), true);
                    }
                }
                return class_9062.field_47729;
            }
        }
        if ((result = FluidItemInteractionHelper.onFluidStorageUse(player, stack, (Storage<FluidVariant>)fluidStorage, world, pos, true, true)) == class_9062.field_47728) {
            luminousBlock.updateBlockWithLight(world.method_8321(pos), world, pos, state);
            return class_9062.field_47728;
        }
        return class_9062.field_47729;
    }

    public static class_9062 tryToDye(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1799 stack, Function<class_1767, class_2248> blockGetter) {
        class_2248 newBlock;
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1769)) {
            return class_9062.field_47731;
        }
        class_1769 dyeItem = (class_1769)class_17922;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return class_9062.field_47731;
        }
        class_1767 newColor = dyeItem.method_7802();
        class_2248 currentBlock = state.method_26204();
        if (currentBlock == (newBlock = blockGetter.apply(newColor))) {
            if (!world.field_9236) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.resprouted.already_dyed").method_27692(class_124.field_1070), true);
            }
            return class_9062.field_47729;
        }
        if (world.field_9236) {
            return class_9062.field_47728;
        }
        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        class_9323 components = blockEntity.method_57590();
        class_2680 newState = newBlock.method_9564();
        for (class_2769 property : state.method_28501()) {
            if (!newState.method_28498(property)) continue;
            newState = BlockUtils.copyProperty(state, newState, property);
        }
        world.method_8652(pos, newState, 35);
        class_2586 newBlockEntity = world.method_8321(pos);
        if (newBlockEntity != null) {
            newBlockEntity.method_58690(nbt, (class_7225.class_7874)world.method_30349());
            newBlockEntity.method_58684(components);
            newBlockEntity.method_5431();
        }
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        world.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
        return class_9062.field_47728;
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }
}

