/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.util.fluid;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.edu.resprouted.fluid.ModFluids;
import net.edu.resprouted.fluid.data.FluidItemMapping;
import net.edu.resprouted.resource.FluidItemLoader;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5328;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class FluidItemInteractionHelper {
    private static final Map<class_2960, class_9331<?>> COMPONENT_TYPE_CACHE = new ConcurrentHashMap();

    public static class_9062 onFluidStorageUse(class_1657 player, class_1799 stack, Storage<FluidVariant> storage, class_1937 world, class_2338 pos, boolean allowInsert, boolean allowExtract) {
        if (player.method_37908().field_9236) {
            return class_9062.field_47733;
        }
        if (allowInsert && FluidItemInteractionHelper.tryInsertFluid(player, stack, storage, world, pos)) {
            return class_9062.field_47728;
        }
        if (allowExtract && FluidItemInteractionHelper.tryExtractFluid(player, stack, storage, world, pos)) {
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    private static boolean tryInsertFluid(class_1657 player, class_1799 stack, Storage<FluidVariant> storage, class_1937 world, class_2338 pos) {
        try (Transaction tx = Transaction.openOuter();){
            for (FluidItemMapping mapping : FluidItemLoader.getEntries()) {
                class_1844 potionContents;
                if (!mapping.direction().allowsInsert() || !class_1799.method_7984((class_1799)stack, (class_1799)mapping.fullItem())) continue;
                if ((mapping.fluid().isOf((Object)ModFluids.POTION) || mapping.fluid().isOf((Object)ModFluids.POTION_FLOWING)) && (potionContents = (class_1844)stack.method_57824(class_9334.field_49651)) != null && potionContents.comp_2378().isPresent() && potionContents.comp_2378().get() == class_1847.field_8991) {
                    FluidVariant waterVariant = FluidVariant.of((class_3611)class_3612.field_15910);
                    long inserted = storage.insert((Object)waterVariant, mapping.amount(), (TransactionContext)tx);
                    if (inserted != mapping.amount()) continue;
                    tx.commit();
                    FluidItemInteractionHelper.handleInsertSuccess(player, stack, mapping, world, pos);
                    boolean bl = true;
                    return bl;
                }
                if (!FluidItemInteractionHelper.canInsertWithComponents(storage, mapping.fluid(), stack, mapping.preservedComponents())) continue;
                FluidVariant fluidWithComponents = FluidItemInteractionHelper.createFluidWithComponents(mapping.fluid(), stack, mapping.preservedComponents());
                long inserted = storage.insert((Object)fluidWithComponents, mapping.amount(), (TransactionContext)tx);
                if (inserted != mapping.amount()) continue;
                tx.commit();
                FluidItemInteractionHelper.handleInsertSuccess(player, stack, mapping, world, pos);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean tryExtractFluid(class_1657 player, class_1799 stack, Storage<FluidVariant> storage, class_1937 world, class_2338 pos) {
        try (Transaction tx = Transaction.openOuter();){
            for (FluidItemMapping mapping : FluidItemLoader.getEntries()) {
                FluidVariant waterVariant;
                long extracted;
                if (!mapping.direction().allowsExtract() || !stack.method_31574(mapping.emptyItem().method_7909())) continue;
                if ((mapping.fluid().isOf((Object)ModFluids.POTION) || mapping.fluid().isOf((Object)ModFluids.POTION_FLOWING)) && stack.method_31574(class_1802.field_8469) && (extracted = storage.extract((Object)(waterVariant = FluidVariant.of((class_3611)class_3612.field_15910)), mapping.amount(), (TransactionContext)tx)) == mapping.amount()) {
                    tx.commit();
                    class_1799 waterBottle = new class_1799((class_1935)class_1802.field_8574);
                    waterBottle.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8991));
                    class_1799 resultStack = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)waterBottle);
                    FluidItemInteractionHelper.updatePlayerHand(player, stack, resultStack);
                    FluidItemInteractionHelper.playSound(world, pos, mapping, false);
                    boolean bl = true;
                    return bl;
                }
                FluidVariant fluidToExtract = FluidItemInteractionHelper.findFluidWithComponents(storage, mapping.fluid());
                FluidVariant extractVariant = fluidToExtract != null ? fluidToExtract : mapping.fluid();
                long extracted2 = storage.extract((Object)extractVariant, mapping.amount(), (TransactionContext)tx);
                if (extracted2 != mapping.amount()) continue;
                tx.commit();
                FluidItemInteractionHelper.handleExtractSuccess(player, stack, mapping, fluidToExtract, world, pos);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void handleInsertSuccess(class_1657 player, class_1799 stack, FluidItemMapping mapping, class_1937 world, class_2338 pos) {
        if (!player.method_7337()) {
            stack.method_7934(1);
            class_1799 empty = mapping.emptyItem().method_7972();
            if (!player.method_31548().method_7394(empty)) {
                player.method_7328(empty, false);
            }
        }
        FluidItemInteractionHelper.playSound(world, pos, mapping, true);
    }

    private static void handleExtractSuccess(class_1657 player, class_1799 stack, FluidItemMapping mapping, FluidVariant fluidToExtract, class_1937 world, class_2338 pos) {
        class_1799 filled = mapping.fullItem().method_7972();
        if (fluidToExtract != null) {
            FluidItemInteractionHelper.applyComponentsFromFluid(fluidToExtract, filled, mapping.preservedComponents());
        }
        class_1799 resultStack = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)filled);
        FluidItemInteractionHelper.updatePlayerHand(player, stack, resultStack);
        FluidItemInteractionHelper.playSound(world, pos, mapping, false);
    }

    private static void updatePlayerHand(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        if (player.method_6047() == oldStack) {
            player.method_6122(class_1268.field_5808, newStack);
        } else if (player.method_6079() == oldStack) {
            player.method_6122(class_1268.field_5810, newStack);
        }
    }

    private static void applyComponentsFromFluid(FluidVariant fluid, class_1799 item, Set<class_2960> preservedComponents) {
        for (class_2960 componentId : preservedComponents) {
            Object fluidValue;
            class_9331<?> componentType = FluidItemInteractionHelper.getComponentType(componentId);
            if (componentType == null || (fluidValue = FluidItemInteractionHelper.unwrapOptional(fluid.getComponents().method_57845(componentType))) == null) continue;
            FluidItemInteractionHelper.setComponentToItem(item, componentType, fluidValue);
        }
    }

    private static <T> void setComponentToItem(class_1799 item, class_9331<T> componentType, Object value) {
        item.method_57379(componentType, value);
    }

    private static boolean canInsertWithComponents(Storage<FluidVariant> storage, FluidVariant fluidToInsert, class_1799 itemStack, Set<class_2960> preservedComponents) {
        if (preservedComponents.isEmpty()) {
            return true;
        }
        for (StorageView view : storage) {
            FluidVariant existingFluid = (FluidVariant)view.getResource();
            if (!existingFluid.isOf((Object)fluidToInsert.getFluid()) || view.getAmount() == 0L || FluidItemInteractionHelper.componentsMatch(existingFluid, itemStack, preservedComponents)) continue;
            return false;
        }
        return true;
    }

    private static boolean componentsMatch(FluidVariant fluid, class_1799 item, Set<class_2960> preservedComponents) {
        for (class_2960 componentId : preservedComponents) {
            class_9331<?> componentType = FluidItemInteractionHelper.getComponentType(componentId);
            if (componentType == null) continue;
            Object itemValue = item.method_57824(componentType);
            Object fluidValue = FluidItemInteractionHelper.unwrapOptional(fluid.getComponents().method_57845(componentType));
            if (itemValue == null || fluidValue == null || itemValue.equals(fluidValue)) continue;
            return false;
        }
        return true;
    }

    private static FluidVariant createFluidWithComponents(FluidVariant baseVariant, class_1799 itemStack, Set<class_2960> preservedComponents) {
        if (preservedComponents.isEmpty()) {
            return baseVariant;
        }
        class_9326.class_9327 builder = class_9326.method_57841();
        for (class_2960 componentId : preservedComponents) {
            Object value;
            class_9331<?> componentType = FluidItemInteractionHelper.getComponentType(componentId);
            if (componentType == null || (value = itemStack.method_57824(componentType)) == null) continue;
            FluidItemInteractionHelper.addComponentToBuilder(builder, componentType, value);
        }
        return baseVariant.withComponentChanges(builder.method_57852());
    }

    private static FluidVariant findFluidWithComponents(Storage<FluidVariant> storage, FluidVariant fluidType) {
        for (StorageView view : storage) {
            FluidVariant resource = (FluidVariant)view.getResource();
            if (!resource.isOf((Object)fluidType.getFluid()) || view.getAmount() <= 0L) continue;
            return resource;
        }
        return null;
    }

    private static <T> void addComponentToBuilder(class_9326.class_9327 builder, class_9331<T> componentType, Object value) {
        builder.method_57854(componentType, value);
    }

    private static class_9331<?> getComponentType(class_2960 componentId) {
        return COMPONENT_TYPE_CACHE.computeIfAbsent(componentId, arg_0 -> ((class_2378)class_7923.field_49658).method_10223(arg_0));
    }

    private static Object unwrapOptional(Object value) {
        Object object;
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            object = opt.orElse(null);
        } else {
            object = value;
        }
        return object;
    }

    private static void playSound(class_1937 world, class_2338 pos, FluidItemMapping mapping, boolean isInsert) {
        class_3414 sound = FluidItemInteractionHelper.getSoundEvent(mapping, isInsert);
        world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
    }

    private static class_3414 getSoundEvent(FluidItemMapping mapping, boolean isInsert) {
        if (mapping.customSound().isPresent()) {
            return (class_3414)class_7923.field_41172.method_10223(mapping.customSound().get());
        }
        if (isInsert) {
            return FluidVariantAttributes.getEmptySound((FluidVariant)mapping.fluid());
        }
        return FluidVariantAttributes.getFillSound((FluidVariant)mapping.fluid());
    }
}

