/*
 * Decompiled with CFR 0.152.
 */
package net.edu.resprouted.util.fluid;

import java.util.Optional;
import net.edu.resprouted.component.ModDataComponentTypes;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3611;
import net.minecraft.class_9326;

public class FluidUtils {
    private static final float DEFAULT_QUALITY = 0.0f;

    public static long convertDropletsToMb(long droplets) {
        return droplets / 81L;
    }

    public static long convertMbToDroplets(long mb) {
        return mb * 81L;
    }

    public static float getQuality(FluidVariant variant) {
        if (variant == null || variant.isBlank()) {
            return 0.0f;
        }
        Optional qualityOpt = variant.getComponents().method_57845(ModDataComponentTypes.FLUID_QUALITY);
        if (qualityOpt != null && qualityOpt.isPresent()) {
            return ((Float)qualityOpt.get()).floatValue();
        }
        return 0.0f;
    }

    public static FluidVariant withQuality(class_3611 fluid, float quality) {
        class_9326.class_9327 builder = class_9326.method_57841();
        builder.method_57854(ModDataComponentTypes.FLUID_QUALITY, (Object)Float.valueOf(Math.max(0.0f, Math.min(1.0f, quality))));
        return FluidVariant.of((class_3611)fluid, (class_9326)builder.method_57852());
    }

    public static FluidVariant withQuality(FluidVariant variant, float quality) {
        class_9326.class_9327 builder = class_9326.method_57841();
        builder.method_57854(ModDataComponentTypes.FLUID_QUALITY, (Object)Float.valueOf(Math.max(0.0f, Math.min(1.0f, quality))));
        return variant.withComponentChanges(builder.method_57852());
    }

    public static boolean hasQuality(FluidVariant variant) {
        if (variant == null || variant.isBlank()) {
            return false;
        }
        Optional qualityOpt = variant.getComponents().method_57845(ModDataComponentTypes.FLUID_QUALITY);
        return qualityOpt != null && qualityOpt.isPresent();
    }
}

