/*
 * Decompiled with CFR 0.152.
 */
package grondag.darkness.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class DarknessSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("darkness.json");
    public boolean darkOverworld = true;
    public boolean darkNether = false;
    public boolean darkEnd = false;
    public boolean requireMod = false;
    public int darknessIntensity = 75;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DarknessSettings load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader2222 = Files.newBufferedReader(CONFIG_PATH);){
                DarknessSettings loaded = (DarknessSettings)GSON.fromJson((Reader)reader2222, DarknessSettings.class);
                if (loaded != null) {
                    loaded.save();
                    DarknessSettings darknessSettings = loaded;
                    return darknessSettings;
                }
            }
            catch (JsonSyntaxException | IOException reader2222) {
                // empty catch block
            }
        }
        DarknessSettings settings = new DarknessSettings();
        settings.save();
        return settings;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

