/*
 * Decompiled with CFR 0.152.
 */
package grondag.darkness.mixin.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import grondag.darkness.Darkness;
import grondag.darkness.DarknessInit;
import grondag.darkness.LightmapAccess;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_11285;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_765.class})
@Environment(value=EnvType.CLIENT)
public class MixinLightTexture
implements LightmapAccess {
    @Shadow
    private float field_21528;
    @Shadow
    private boolean field_4135;
    @Shadow
    @Final
    private class_757 field_4134;
    @Shadow
    @Final
    private class_310 field_4137;
    @Shadow
    @Final
    private GpuTexture field_57927;
    @Shadow
    @Final
    private GpuTextureView field_60581;
    @Shadow
    @Final
    private class_11285 field_60112;

    @Shadow
    private float method_42596(class_1309 livingEntity, float f, float g) {
        throw new AssertionError();
    }

    @Inject(method={"method_3313"}, at={@At(value="HEAD")}, cancellable=true)
    private void darkness_updateLightTexture(float f, CallbackInfo ci) {
        if (!Darkness.enabled) {
            return;
        }
        ci.cancel();
        if (this.field_4135) {
            this.field_4135 = false;
            class_3695 profilerFiller = class_10209.method_64146();
            profilerFiller.method_15396("lightTex");
            class_638 clientLevel = this.field_4137.field_1687;
            if (clientLevel != null) {
                float skyDarken = clientLevel.method_23783(1.0f);
                float ambientLight = clientLevel.method_8597().comp_656();
                float skyFactor = clientLevel.method_23789() > 0 ? 1.0f : skyDarken * 0.95f + 0.05f;
                Vector3f skyLightColor = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                skyFactor *= Darkness.skyDarkness;
                skyLightColor.mul(Darkness.skyDarkness);
                float darknessEffectScale = ((Double)this.field_4137.field_1690.method_42472().method_41753()).floatValue();
                float darknessGamma = this.field_4137.field_1724.method_66279(class_1294.field_38092, f) * darknessEffectScale;
                float darknessScale = this.method_42596((class_1309)this.field_4137.field_1724, darknessGamma, f) * darknessEffectScale;
                float intensityFactor = (float)DarknessInit.CONFIG.darknessIntensity / 100.0f;
                darknessScale = Math.max(darknessScale, (1.0f - Darkness.skyDarkness) * intensityFactor * 0.15f);
                float waterVision = this.field_4137.field_1724.method_3140();
                float nightVisionFactor = this.field_4137.field_1724.method_6059(class_1294.field_5925) ? class_757.method_3174((class_1309)this.field_4137.field_1724, (float)f) : (waterVision > 0.0f && this.field_4137.field_1724.method_6059(class_1294.field_5927) ? waterVision : 0.0f);
                float blockFactor = this.field_21528 + 1.5f;
                boolean useBrightLightmap = clientLevel.method_28103().method_28114();
                float gamma = ((Double)this.field_4137.field_1690.method_42473().method_41753()).floatValue();
                gamma *= Darkness.skyDarkness;
                CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
                try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(this.field_60112.method_71119(), false, true);){
                    Std140Builder.intoBuffer((ByteBuffer)mappedView.data()).putFloat(ambientLight).putFloat(skyFactor).putFloat(blockFactor).putInt(useBrightLightmap ? 1 : 0).putFloat(nightVisionFactor).putFloat(darknessScale).putFloat(this.field_4134.method_3195(f)).putFloat(Math.max(0.0f, gamma - darknessGamma)).putVec3((Vector3fc)skyLightColor);
                }
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
                GpuBuffer gpuBuffer = autoStorageIndexBuffer.method_68274(6);
                try (RenderPass renderPass = commandEncoder.createRenderPass(() -> "Update light", this.field_60581, OptionalInt.empty());){
                    renderPass.setPipeline(class_10799.field_56844);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("LightmapInfo", this.field_60112.method_71119());
                    renderPass.setVertexBuffer(0, RenderSystem.getQuadVertexBuffer());
                    renderPass.setIndexBuffer(gpuBuffer, autoStorageIndexBuffer.method_31924());
                    renderPass.drawIndexed(0, 0, 6, 1);
                }
                this.field_60112.method_71121();
                profilerFiller.method_15407();
            }
        }
    }

    @Override
    public float darkness_prevFlicker() {
        return this.field_21528;
    }

    @Override
    public boolean darkness_isDirty() {
        return this.field_4135;
    }
}

