/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights;

import com.mojang.logging.LogUtils;
import java.time.Month;
import java.util.function.Supplier;
import me.paulf.fairylights.client.net.ClientMessageHandlers;
import me.paulf.fairylights.server.ServerEventHandler;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.ConnectionTypes;
import me.paulf.fairylights.server.creativetabs.FairyLightsItemGroup;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.net.ClientMessageContext;
import me.paulf.fairylights.server.net.NetBuilder;
import me.paulf.fairylights.server.net.clientbound.JingleMessage;
import me.paulf.fairylights.server.net.clientbound.OpenEditLetteredConnectionScreenMessage;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import me.paulf.fairylights.server.net.serverbound.EditLetteredConnectionMessage;
import me.paulf.fairylights.server.net.serverbound.InteractionConnectionMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.CalendarEvent;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="fairylights")
public final class FairyLights {
    public static final String ID = "fairylights";
    public static final ResourceLocation STRING_TYPE = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"string_type");
    public static final ResourceLocation CONNECTION_TYPE = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"connection_type");
    public static final Object NETWORK = new NetBuilder(ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"net")).version(1).optionalServer().requiredClient().clientbound(JingleMessage::new).consumer(() -> (msg, ctx) -> {
        if (FMLEnvironment.dist.isClient()) {
            ClientMessageHandlers.handleJingle(msg, ctx);
        }
    }).clientbound(() -> new UpdateEntityFastenerMessage(0, new CompoundTag())).consumer(() -> (msg, ctx) -> {
        if (FMLEnvironment.dist.isClient()) {
            ClientMessageHandlers.handleUpdateEntityFastener(msg, ctx);
        }
    }).clientbound(OpenEditLetteredConnectionScreenMessage::new).consumer(() -> (msg, ctx) -> {
        if (FMLEnvironment.dist.isClient()) {
            ClientMessageHandlers.handleOpenScreen(msg, ctx);
        }
    }).serverbound(InteractionConnectionMessage::new).consumer(() -> new InteractionConnectionMessage.Handler()).serverbound(EditLetteredConnectionMessage::new).consumer(() -> new EditLetteredConnectionMessage.Handler()).build();
    public static final CalendarEvent CHRISTMAS = new CalendarEvent(Month.DECEMBER, 24, 26);
    public static final CalendarEvent HALLOWEEN = new CalendarEvent(Month.OCTOBER, 31, 31);
    public static Supplier<Registry<ConnectionType<?>>> CONNECTION_TYPES;
    public static Supplier<Registry<StringType>> STRING_TYPES;

    public FairyLights(IEventBus modEventBus) {
        ServerProxy proxy;
        IEventBus bus = modEventBus;
        FLSounds.REG.register(bus);
        FLBlocks.REG.register(bus);
        FLEntities.REG.register(bus);
        FLItems.REG.register(bus);
        FLBlockEntities.REG.register(bus);
        FLCraftingRecipes.REG.register(bus);
        ConnectionTypes.REG.register(bus);
        StringTypes.REG.register(bus);
        FLDataComponents.REG.register(bus);
        CONNECTION_TYPES = () -> {
            try {
                return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY).registryOrThrow(ResourceKey.createRegistryKey((ResourceLocation)CONNECTION_TYPE));
            }
            catch (Exception e) {
                LogUtils.getLogger().error("FL_DEBUG: Failed to get CONNECTION_TYPES registry", (Throwable)e);
                throw e;
            }
        };
        STRING_TYPES = () -> {
            try {
                return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY).registryOrThrow(ResourceKey.createRegistryKey((ResourceLocation)STRING_TYPE));
            }
            catch (Exception e) {
                LogUtils.getLogger().error("FL_DEBUG: Failed to get STRING_TYPES registry", (Throwable)e);
                throw e;
            }
        };
        if (FMLEnvironment.dist.isClient()) {
            try {
                proxy = (ServerProxy)Class.forName("me.paulf.fairylights.client.ClientProxy").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate ClientProxy", e);
            }
        } else {
            proxy = new ServerProxy();
        }
        proxy.init(bus);
        FairyLightsItemGroup.TAB_REG.register(modEventBus);
        modEventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar(ID);
            NetBuilder network = (NetBuilder)NETWORK;
            network.setRegistrar(registrar);
            registrar.playToClient(UpdateEntityFastenerMessage.TYPE, UpdateEntityFastenerMessage.STREAM_CODEC, (msg, ctx) -> {
                if (FMLEnvironment.dist.isClient()) {
                    ClientMessageHandlers.handleUpdateEntityFastener(msg, new ClientMessageContext(ctx));
                }
            });
            registrar.playToClient(OpenEditLetteredConnectionScreenMessage.TYPE, OpenEditLetteredConnectionScreenMessage.STREAM_CODEC, (msg, ctx) -> {
                if (FMLEnvironment.dist.isClient()) {
                    ClientMessageHandlers.handleOpenScreen(msg, new ClientMessageContext(ctx));
                }
            });
            registrar.playToServer(EditLetteredConnectionMessage.TYPE, EditLetteredConnectionMessage.STREAM_CODEC, EditLetteredConnectionMessage::handle);
            registrar.playToServer(InteractionConnectionMessage.TYPE, InteractionConnectionMessage.STREAM_CODEC, InteractionConnectionMessage::handle);
        });
        NeoForge.EVENT_BUS.register(ServerEventHandler.class);
    }
}

