/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.CollectFastenersEvent;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.util.Curve;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public final class ClientEventHandler {
    private static final float HIGHLIGHT_ALPHA = 0.4f;
    public static final Set<UUID> RENDERED_CONNECTIONS = ConcurrentHashMap.newKeySet();
    private static int lastFrame = -1;
    private static FastenerRenderer fastenerRenderer;
    private static HitConnection lastHitConnection;
    private static String lastComponentDescription;
    private static final Logger LOGGER;
    private static int tickCounter;
    private static HitConnection currentHoveredHitConnection;

    @Nullable
    public static Connection getHitConnection() {
        Entity entity;
        net.minecraft.world.phys.HitResult result = Minecraft.getInstance().hitResult;
        if (result instanceof EntityHitResult && (entity = ((EntityHitResult)result).getEntity()) instanceof HitConnection) {
            return ((HitConnection)entity).result.connection;
        }
        return null;
    }

    public void renderOverlay(Gui gui, GuiGraphics poseStack, float partialTick, int screenWidth, int screenHeight) {
        Connection conn = ClientEventHandler.getHitConnection();
        if (!(conn instanceof HangingLightsConnection)) {
            return;
        }
        Jingle jingle = ((HangingLightsConnection)conn).getPlayingJingle();
        if (jingle == null) {
            return;
        }
        List<CallSite> lines = List.of("Song: " + jingle.getTitle(), "Artist: " + jingle.getArtist());
        Font font = Minecraft.getInstance().font;
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)((Object)lines.get(i));
            if (Strings.isNullOrEmpty((String)line)) continue;
            Objects.requireNonNull(font);
            int lineHeight = 9;
            int textWidth = font.width(line);
            int y = 2 + lineHeight * i;
            poseStack.fill(1, y - 1, 2 + textWidth + 1, y + lineHeight - 1, -1873784752);
            poseStack.drawString(font, line, 2, y, 0xE0E0E0);
        }
    }

    private static String getComponentDescription(HitResult result) {
        boolean isCord = result.intersection.getFeatureType() == Connection.CORD_FEATURE;
        boolean isFeature = result.intersection.getFeature() instanceof Light;
        if (result.connection instanceof HangingLightsConnection) {
            HangingLightsConnection conn = (HangingLightsConnection)result.connection;
            if (isFeature) {
                int lightIndex = result.intersection.getFeature().getId();
                Light[] lights = (Light[])conn.getFeatures();
                if (lightIndex >= 0 && lightIndex < lights.length) {
                    Light light = lights[lightIndex];
                    ItemStack lightItem = light.getItem();
                    String lightName = lightItem.isEmpty() ? "Empty" : lightItem.getDisplayName().getString();
                    return String.format("LIGHT[%d]: %s", lightIndex, lightName);
                }
                return String.format("LIGHT[%d]", lightIndex);
            }
            if (isCord) {
                return "ROPE/WIRE";
            }
        }
        String typeName = isCord ? "CORD" : (isFeature ? "FEATURE" : "TYPE_" + result.intersection.getFeatureType().getId());
        return typeName + "[" + result.intersection.getFeature().getId() + "]";
    }

    public static void updateHitConnection() {
        if (++tickCounter % 20 == 0) {
            LOGGER.info("FL_DEBUG: updateHitConnection() called (tick " + tickCounter + ")");
        }
        Minecraft mc = Minecraft.getInstance();
        Entity viewer = mc.getCameraEntity();
        if (mc.hitResult != null && mc.level != null && viewer != null) {
            BlockHitResult blockHit;
            BlockState blockState;
            EntityHitResult entityHit;
            net.minecraft.world.phys.HitResult entity;
            net.minecraft.world.phys.HitResult hitResult = mc.hitResult;
            if (hitResult instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)hitResult).getEntity()) instanceof FenceFastenerEntity) {
                String desc = "FASTENER[FENCE]";
                if (!"FASTENER[FENCE]".equals(lastComponentDescription)) {
                    LOGGER.info("FL_DEBUG: MOUSEOVER - FASTENER[FENCE] at " + String.valueOf(entityHit.getLocation()));
                    lastComponentDescription = "FASTENER[FENCE]";
                    lastHitConnection = null;
                }
                return;
            }
            entity = mc.hitResult;
            if (entity instanceof BlockHitResult && (blockState = mc.level.getBlockState((blockHit = (BlockHitResult)entity).getBlockPos())).getBlock() == FLBlocks.FASTENER.get()) {
                String desc = "FASTENER[BLOCK] at " + String.valueOf(blockHit.getBlockPos());
                if (!desc.equals(lastComponentDescription)) {
                    LOGGER.info("FL_DEBUG: MOUSEOVER - " + desc);
                    lastComponentDescription = desc;
                    lastHitConnection = null;
                }
                return;
            }
            HitResult result = ClientEventHandler.getHitConnection((Level)mc.level, viewer);
            if (result != null) {
                Vec3 eyes = viewer.getEyePosition(1.0f);
                if (result.intersection.getResult().distanceTo(eyes) < mc.hitResult.getLocation().distanceTo(eyes)) {
                    HitConnection hitConnection = new HitConnection((Level)mc.level, result);
                    mc.hitResult = new EntityHitResult((Entity)hitConnection);
                    mc.crosshairPickEntity = null;
                    currentHoveredHitConnection = hitConnection;
                    String componentDesc = ClientEventHandler.getComponentDescription(result);
                    if (lastHitConnection == null || !ClientEventHandler.lastHitConnection.result.connection.getUUID().equals(result.connection.getUUID()) || ClientEventHandler.lastHitConnection.result.intersection.getFeature().getId() != result.intersection.getFeature().getId() || !componentDesc.equals(lastComponentDescription)) {
                        LOGGER.info("FL_DEBUG: MOUSEOVER - Connection: " + String.valueOf(result.connection.getUUID()) + " Component: " + componentDesc + " FeatureType=" + result.intersection.getFeatureType().getId() + " FeatureId=" + result.intersection.getFeature().getId() + " HitPos=" + String.valueOf(result.intersection.getResult()));
                        lastHitConnection = hitConnection;
                        lastComponentDescription = componentDesc;
                    }
                } else if (lastHitConnection != null) {
                    LOGGER.info("FL_DEBUG: MOUSEOVER - No longer over connection (block/entity closer)");
                    lastHitConnection = null;
                    lastComponentDescription = null;
                    currentHoveredHitConnection = null;
                }
            } else if (lastHitConnection != null) {
                LOGGER.info("FL_DEBUG: MOUSEOVER - No connection found in raycast");
                lastHitConnection = null;
                lastComponentDescription = null;
                currentHoveredHitConnection = null;
            }
        }
    }

    @Nullable
    private static HitResult getHitConnection(Level world, Entity viewer) {
        Set<Fastener<?>> fasteners;
        AABB bounds = new AABB(viewer.blockPosition()).inflate(33.0);
        HitResult result = ClientEventHandler.getHitConnection(viewer, bounds, fasteners = ClientEventHandler.collectFasteners(world, bounds));
        if (result == null && fasteners.size() > 0) {
            System.out.println("FL_DEBUG: Raycast found " + fasteners.size() + " fasteners but no connection hit");
        }
        return result;
    }

    private static Set<Fastener<?>> collectFasteners(Level world, AABB bounds) {
        LinkedHashSet fasteners = Sets.newLinkedHashSet();
        CollectFastenersEvent event = new CollectFastenersEvent(world, bounds, fasteners);
        world.getEntitiesOfClass(FenceFastenerEntity.class, bounds).forEach(event::accept);
        int minX = Mth.floor((double)(bounds.minX / 16.0));
        int maxX = Mth.ceil((double)(bounds.maxX / 16.0));
        int minZ = Mth.floor((double)(bounds.minZ / 16.0));
        int maxZ = Mth.ceil((double)(bounds.maxZ / 16.0));
        ChunkSource provider = world.getChunkSource();
        int chunkCount = 0;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                LevelChunk chunk = provider.getChunk(x, z, false);
                if (chunk == null) continue;
                event.accept(chunk);
                ++chunkCount;
            }
        }
        NeoForge.EVENT_BUS.post((Event)event);
        return fasteners;
    }

    @Nullable
    private static HitResult getHitConnection(Entity viewer, AABB bounds, Set<Fastener<?>> fasteners) {
        if (fasteners.isEmpty()) {
            return null;
        }
        Vec3 origin = viewer.getEyePosition(1.0f);
        Vec3 look = viewer.getLookAngle();
        double reach = 6.0;
        Vec3 end = origin.add(look.x * 6.0, look.y * 6.0, look.z * 6.0);
        Connection found = null;
        Intersection rayTrace = null;
        double distance = Double.MAX_VALUE;
        int connectionCount = 0;
        int intersectionCount = 0;
        for (Fastener<?> fastener : fasteners) {
            for (Connection connection : fastener.getOwnConnections()) {
                Collidable collision;
                Intersection result;
                ++connectionCount;
                if (connection.getDestination().getType() == FastenerType.PLAYER || (result = (collision = connection.getCollision()).intersect(origin, end)) == null) continue;
                ++intersectionCount;
                double dist = result.getResult().distanceTo(origin);
                if (!(dist < distance)) continue;
                distance = dist;
                found = connection;
                rayTrace = result;
            }
        }
        if (connectionCount > 0 && found == null && tickCounter % 100 == 0) {
            LOGGER.info("FL_DEBUG: Raycast checked " + connectionCount + " connections, " + intersectionCount + " intersections, but none were closest");
        }
        if (found == null) {
            return null;
        }
        return new HitResult(found, rayTrace);
    }

    @SubscribeEvent
    public void drawBlockHighlight(RenderHighlightEvent.Block event) {
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof HitConnection) {
            HitConnection hitConnection = (HitConnection)entity;
            LOGGER.info("FL_DEBUG: EntityInteract event caught for HitConnection");
            hitConnection.processAction(PlayerAction.INTERACT);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof HitConnection) {
            HitConnection hitConnection = (HitConnection)entity;
            LOGGER.info("FL_DEBUG: AttackEntityEvent caught for HitConnection");
            hitConnection.processAction(PlayerAction.ATTACK);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof HitConnection) {
            HitConnection hitConnection = (HitConnection)entity;
            LOGGER.info("FL_DEBUG: EntityInteractSpecific event caught for HitConnection");
            hitConnection.processAction(PlayerAction.INTERACT);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        EntityHitResult entityHit;
        Minecraft mc = Minecraft.getInstance();
        HitConnection target = null;
        net.minecraft.world.phys.HitResult hitResult = mc.hitResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).getEntity()) instanceof HitConnection) {
            HitConnection hitConnection;
            target = hitConnection = (HitConnection)hitResult;
        } else if (currentHoveredHitConnection != null) {
            target = currentHoveredHitConnection;
        }
        if (target != null) {
            LOGGER.info("FL_DEBUG: RightClickEmpty event - processing HitConnection interaction");
            target.processAction(PlayerAction.INTERACT);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityHitResult entityHit;
        Minecraft mc = Minecraft.getInstance();
        HitConnection target = null;
        net.minecraft.world.phys.HitResult hitResult = mc.hitResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).getEntity()) instanceof HitConnection) {
            HitConnection hitConnection;
            target = hitConnection = (HitConnection)hitResult;
        } else if (currentHoveredHitConnection != null) {
            target = currentHoveredHitConnection;
        }
        if (target != null) {
            LOGGER.info("FL_DEBUG: RightClickItem event - processing HitConnection interaction");
            target.processAction(PlayerAction.INTERACT);
        }
    }

    private void drawFenceFastenerHighlight(FenceFastenerEntity fence, PoseStack matrix, VertexConsumer buf, float delta, double dx, double dy, double dz) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (player.hasLineOfSight((Entity)fence) || player.distanceToSqr((Entity)fence) <= 9.0)) {
            AABB selection = fence.getBoundingBox().move(-dx, -dy, -dz).inflate(0.002);
            LevelRenderer.renderLineBox((PoseStack)matrix, (VertexConsumer)buf, (AABB)selection, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    private void renderHighlight(Connection connection, PoseStack matrix, VertexConsumer buf) {
        Curve cat = connection.getCatenary();
        if (cat == null) {
            return;
        }
        Vector3f p = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        LineBuilder builder = new LineBuilder(matrix, buf);
        float r = connection.getRadius() + 0.01f;
        for (int edge = 0; edge < 4; ++edge) {
            int n;
            p.set(cat.getX(0), cat.getY(0), cat.getZ(0));
            v1.set(cat.getDx(0), cat.getDy(0), cat.getDz(0));
            v1.normalize();
            v2.set(-v1.x(), -v1.y(), -v1.z());
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
            this.addVertex(builder, edge, p, v1, v2, r);
            for (int i = 1; i < cat.getCount() - 1; ++i) {
                p.set(cat.getX(i), cat.getY(i), cat.getZ(i));
                v2.set(-cat.getDx(i), -cat.getDy(i), -cat.getDz(i));
                v2.normalize();
                this.addVertex(builder, edge, p, v1, v2, r);
                this.addVertex(builder, edge, p, v1, v2, r);
                v1.set(-v2.x(), -v2.y(), -v2.z());
            }
            p.set(cat.getX(), cat.getY(), cat.getZ());
            v2.set(-v1.x(), -v1.y(), -v1.z());
            this.addVertex(builder, edge, p, v1, v2, r);
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
        }
    }

    private void addVertex(LineBuilder builder, int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        builder.accept(this.get(edge, p, v1, v2, r));
    }

    private static void addVertexToBuffer(VertexConsumer buf, Vector3f pos, Vector3f normal, float alpha) {
        try {
            Method vertexMethod = VertexConsumer.class.getMethod("vertex", Double.TYPE, Double.TYPE, Double.TYPE);
            Object v = vertexMethod.invoke((Object)buf, pos.x(), pos.y(), pos.z());
            Method colorMethod = VertexConsumer.class.getMethod("color", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method normalMethod = VertexConsumer.class.getMethod("normal", Float.TYPE, Float.TYPE, Float.TYPE);
            Method endVertexMethod = VertexConsumer.class.getMethod("endVertex", new Class[0]);
            colorMethod.invoke(v, 0, 0, 0, (int)(alpha * 255.0f));
            normalMethod.invoke(v, Float.valueOf(normal.x()), Float.valueOf(normal.y()), Float.valueOf(normal.z()));
            endVertexMethod.invoke(v, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector3f get(int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        Vector3f up = new Vector3f();
        Vector3f side = new Vector3f();
        if (v1.dot((Vector3fc)v2) < -0.99f) {
            float h = Mth.sqrt((float)(v1.x() * v1.x() + v1.z() * v1.z()));
            if (h < 0.01f) {
                up.set(-1.0f, 0.0f, 0.0f);
            } else {
                up.set(-v1.x() / h * -v1.y(), -h, -v1.z() / h * -v1.y());
            }
        } else {
            up.set(v2.x(), v2.y(), v2.z());
            up.lerp((Vector3fc)v1, 0.5f);
        }
        up.normalize();
        side.set(v1.x(), v1.y(), v1.z());
        side.cross((Vector3fc)up);
        side.normalize();
        side.mul(edge == 0 || edge == 3 ? -r : r);
        up.mul(edge < 2 ? -r : r);
        up.add((Vector3fc)side);
        up.add((Vector3fc)p);
        return up;
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            RENDERED_CONNECTIONS.clear();
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        Vec3 cameraPos = event.getCamera().getPosition();
        if (fastenerRenderer == null) {
            fastenerRenderer = new FastenerRenderer(arg_0 -> ((EntityModelSet)mc.getEntityModels()).bakeLayer(arg_0));
        }
        AABB searchBounds = new AABB(player.blockPosition()).inflate(64.0);
        Set<Fastener<?>> fasteners = ClientEventHandler.collectFasteners((Level)mc.level, searchBounds);
        CapabilityHandler.getFastenerCapability((Entity)player).ifPresent(fasteners::add);
        for (Fastener<?> fastener : fasteners) {
            if (fastener.hasNoConnections()) continue;
            poseStack.pushPose();
            Vec3 connPoint = fastener.getConnectionPoint();
            poseStack.translate(connPoint.x - cameraPos.x, connPoint.y - cameraPos.y, connPoint.z - cameraPos.z);
            int packedLight = LightTexture.pack((int)mc.level.getBrightness(LightLayer.BLOCK, fastener.getPos()), (int)mc.level.getBrightness(LightLayer.SKY, fastener.getPos()));
            fastenerRenderer.render(fastener, partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        bufferSource.endBatch();
    }

    static {
        lastHitConnection = null;
        lastComponentDescription = null;
        LOGGER = LogUtils.getLogger();
        tickCounter = 0;
        currentHoveredHitConnection = null;
    }

    static class HitConnection
    extends Entity {
        final HitResult result;

        HitConnection(Level world, HitResult result) {
            super(EntityType.ITEM, world);
            this.setId(-1);
            this.result = result;
            this.setPos(result.intersection.getResult());
        }

        public boolean hurt(DamageSource source, float amount) {
            if (source.getEntity() == Minecraft.getInstance().player) {
                this.processAction(PlayerAction.ATTACK);
                return true;
            }
            return false;
        }

        public InteractionResult interact(Player player, InteractionHand hand) {
            if (player == Minecraft.getInstance().player) {
                LogUtils.getLogger().info("FL_DEBUG: HitConnection.interact() called");
                this.processAction(PlayerAction.INTERACT);
                return InteractionResult.SUCCESS;
            }
            return super.interact(player, hand);
        }

        public void processAction(PlayerAction action) {
            this.result.connection.processClientAction((Player)Minecraft.getInstance().player, action, this.result.intersection);
        }

        public ItemStack getPickedResult(net.minecraft.world.phys.HitResult target) {
            return this.result.connection.getItemStack();
        }

        protected void defineSynchedData(SynchedEntityData.Builder builder) {
        }

        protected void addAdditionalSaveData(CompoundTag compound) {
        }

        protected void readAdditionalSaveData(CompoundTag compound) {
        }
    }

    private static final class HitResult {
        private final Connection connection;
        private final Intersection intersection;

        public HitResult(Connection connection, Intersection intersection) {
            this.connection = connection;
            this.intersection = intersection;
        }
    }

    static class LineBuilder {
        final PoseStack matrix;
        final VertexConsumer buf;
        Vector3f last;

        LineBuilder(PoseStack matrix, VertexConsumer buf) {
            this.matrix = matrix;
            this.buf = buf;
        }

        void accept(Vector3f pos) {
            if (this.last == null) {
                this.last = pos;
            } else {
                Vector3f n = new Vector3f((Vector3fc)pos);
                n.sub((Vector3fc)this.last);
                n.normalize();
                n = this.matrix.last().normal().transform(n);
                Matrix4f pose = this.matrix.last().pose();
                Vector3f lastVec3 = new Vector3f(this.last.x(), this.last.y(), this.last.z());
                Vector3f posVec3 = new Vector3f(pos.x(), pos.y(), pos.z());
                pose.transformPosition(lastVec3);
                pose.transformPosition(posVec3);
                ClientEventHandler.addVertexToBuffer(this.buf, lastVec3, n, 0.4f);
                ClientEventHandler.addVertexToBuffer(this.buf, posVec3, n, 0.4f);
                this.last = null;
            }
        }
    }
}

