/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.ClientEventHandler;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.command.JinglerCommand;
import me.paulf.fairylights.client.model.light.BowModel;
import me.paulf.fairylights.client.model.light.CandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorCandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorOilLanternModel;
import me.paulf.fairylights.client.model.light.FairyLightModel;
import me.paulf.fairylights.client.model.light.FlowerLightModel;
import me.paulf.fairylights.client.model.light.GhostLightModel;
import me.paulf.fairylights.client.model.light.HeartLightModel;
import me.paulf.fairylights.client.model.light.IcicleLightsModel;
import me.paulf.fairylights.client.model.light.IncandescentLightModel;
import me.paulf.fairylights.client.model.light.JackOLanternLightModel;
import me.paulf.fairylights.client.model.light.MeteorLightModel;
import me.paulf.fairylights.client.model.light.MoonLightModel;
import me.paulf.fairylights.client.model.light.OilLanternModel;
import me.paulf.fairylights.client.model.light.OrbLanternModel;
import me.paulf.fairylights.client.model.light.PaperLanternModel;
import me.paulf.fairylights.client.model.light.SkullLightModel;
import me.paulf.fairylights.client.model.light.SnowflakeLightModel;
import me.paulf.fairylights.client.model.light.SpiderLightModel;
import me.paulf.fairylights.client.model.light.StarLightModel;
import me.paulf.fairylights.client.model.light.WitchLightModel;
import me.paulf.fairylights.client.renderer.block.entity.FastenerBlockEntityRenderer;
import me.paulf.fairylights.client.renderer.block.entity.GarlandTinselRenderer;
import me.paulf.fairylights.client.renderer.block.entity.GarlandVineRenderer;
import me.paulf.fairylights.client.renderer.block.entity.HangingLightsRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LetterBuntingRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LightBlockEntityRenderer;
import me.paulf.fairylights.client.renderer.block.entity.PennantBuntingRenderer;
import me.paulf.fairylights.client.renderer.entity.FenceFastenerRenderer;
import me.paulf.fairylights.client.tutorial.ClippyController;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.feature.light.ColorChangingBehavior;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;

public final class ClientProxy
extends ServerProxy {
    public static final Material SOLID_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"entity/connections"));
    public static final Material TRANSLUCENT_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"entity/connections"));
    private final ImmutableList<ResourceLocation> entityModels = new ImmutableList.Builder().addAll(PennantBuntingRenderer.MODELS).addAll((Iterable)LetterBuntingRenderer.MODELS.values()).build();

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        new ClippyController().init(modBus);
        LogUtils.getLogger().info("FL_DEBUG: ClientProxy.init() called - registering client event handlers");
        ClientEventHandler clientEventHandler = new ClientEventHandler();
        NeoForge.EVENT_BUS.register((Object)clientEventHandler);
        LogUtils.getLogger().info("FL_DEBUG: ClientEventHandler registered");
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getEntity() instanceof LocalPlayer) {
                ClientEventHandler.updateHitConnection();
            }
        });
        LogUtils.getLogger().info("FL_DEBUG: EntityTickEvent.Post listener registered for LocalPlayer");
        modBus.addListener(e -> {});
        NeoForge.EVENT_BUS.addListener(e -> JinglerCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        modBus.addListener(this::setup);
        modBus.addListener(this::setupLayerDefinitions);
        modBus.addListener(this::setupColors);
        modBus.addListener(this::setupModels);
    }

    private int getUvIndex(VertexFormat vertexFormat) {
        int position = 0;
        for (VertexFormatElement ee : vertexFormat.getElements()) {
            try {
                String usageStr;
                Method getUsage = ee.getClass().getMethod("getUsage", new Class[0]);
                Object usage = getUsage.invoke((Object)ee, new Object[0]);
                if (usage != null && ((usageStr = usage.toString()).contains("UV") || usageStr.endsWith("UV") || usageStr.equals("UV"))) {
                    if (position % 4 != 0) break;
                    return position / 4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            position += ee.byteSize();
        }
        return -1;
    }

    private void recomputeUv(int stride, int finalUvOffset, BakedModel model) {
        TextureAtlasSprite sprite = model.getParticleIcon(ModelData.EMPTY);
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uSize = uMax - uMin;
        float vSize = vMax - vMin;
        int w = (int)(uSize / (sprite.getU1() - sprite.getU0()));
        int h = (int)(vSize / (sprite.getV1() - sprite.getV0()));
        for (BakedQuad quad : model.getQuads(null, null, RandomSource.create((long)42L), ModelData.EMPTY, RenderType.cutoutMipped())) {
            int[] data = quad.getVertices();
            for (int n = 0; n < 4; ++n) {
                int iu = n * stride + finalUvOffset;
                int iv = n * stride + finalUvOffset + 1;
                data[iu] = Float.floatToIntBits((float)Math.round(Float.intBitsToFloat(data[iu]) * (float)w) / (float)w);
                data[iv] = Float.floatToIntBits((float)Math.round(Float.intBitsToFloat(data[iv]) * (float)h) / (float)h);
            }
        }
    }

    private void setup(FMLClientSetupEvent event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FLBlockEntities.FASTENER.get()), context -> new FastenerBlockEntityRenderer(context, ServerProxy.buildBlockView()));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FLBlockEntities.LIGHT.get()), LightBlockEntityRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)FLEntities.FASTENER.get()), FenceFastenerRenderer::new);
    }

    private void setupLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FLModelLayers.BOW, BowModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.GARLAND_RINGS, GarlandVineRenderer.RingsModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.TINSEL_STRIP, GarlandTinselRenderer.StripModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.FAIRY_LIGHT, FairyLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.PAPER_LANTERN, PaperLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.ORB_LANTERN, OrbLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.FLOWER_LIGHT, FlowerLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.CANDLE_LANTERN_LIGHT, ColorCandleLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.OIL_LANTERN_LIGHT, ColorOilLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.JACK_O_LANTERN, JackOLanternLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.SKULL_LIGHT, SkullLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.GHOST_LIGHT, GhostLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.SPIDER_LIGHT, SpiderLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.WITCH_LIGHT, WitchLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.SNOWFLAKE_LIGHT, SnowflakeLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.HEART_LIGHT, HeartLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.MOON_LIGHT, MoonLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.STAR_LIGHT, StarLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.ICICLE_LIGHTS_1, () -> IcicleLightsModel.createLayer(1));
        event.registerLayerDefinition(FLModelLayers.ICICLE_LIGHTS_2, () -> IcicleLightsModel.createLayer(2));
        event.registerLayerDefinition(FLModelLayers.ICICLE_LIGHTS_3, () -> IcicleLightsModel.createLayer(3));
        event.registerLayerDefinition(FLModelLayers.ICICLE_LIGHTS_4, () -> IcicleLightsModel.createLayer(4));
        event.registerLayerDefinition(FLModelLayers.METEOR_LIGHT, MeteorLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.OIL_LANTERN, OilLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.CANDLE_LANTERN, CandleLanternModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.INCANDESCENT_LIGHT, IncandescentLightModel::createLayer);
        event.registerLayerDefinition(FLModelLayers.LETTER_WIRE, LetterBuntingRenderer::wireLayer);
        event.registerLayerDefinition(FLModelLayers.PENNANT_WIRE, PennantBuntingRenderer::wireLayer);
        event.registerLayerDefinition(FLModelLayers.TINSEL_WIRE, GarlandTinselRenderer::wireLayer);
        event.registerLayerDefinition(FLModelLayers.VINE_WIRE, GarlandVineRenderer::wireLayer);
        event.registerLayerDefinition(FLModelLayers.LIGHTS_WIRE, HangingLightsRenderer::wireLayer);
    }

    private void setupModels(ModelEvent.RegisterAdditional event) {
        event.register(new ModelResourceLocation(FenceFastenerRenderer.MODEL, "standalone"));
        this.entityModels.forEach(model -> event.register(new ModelResourceLocation(model, "standalone")));
    }

    private void setupColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, index) -> {
            if (index == 1) {
                if (ColorChangingBehavior.exists(stack)) {
                    return ColorChangingBehavior.animate(stack);
                }
                return DyeableItem.getColor(stack);
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)FLItems.FAIRY_LIGHT.get(), (ItemLike)FLItems.PAPER_LANTERN.get(), (ItemLike)FLItems.ORB_LANTERN.get(), (ItemLike)FLItems.FLOWER_LIGHT.get(), (ItemLike)FLItems.CANDLE_LANTERN_LIGHT.get(), (ItemLike)FLItems.OIL_LANTERN_LIGHT.get(), (ItemLike)FLItems.JACK_O_LANTERN.get(), (ItemLike)FLItems.SKULL_LIGHT.get(), (ItemLike)FLItems.GHOST_LIGHT.get(), (ItemLike)FLItems.SPIDER_LIGHT.get(), (ItemLike)FLItems.WITCH_LIGHT.get(), (ItemLike)FLItems.SNOWFLAKE_LIGHT.get(), (ItemLike)FLItems.HEART_LIGHT.get(), (ItemLike)FLItems.MOON_LIGHT.get(), (ItemLike)FLItems.STAR_LIGHT.get(), (ItemLike)FLItems.ICICLE_LIGHTS.get(), (ItemLike)FLItems.METEOR_LIGHT.get()});
        event.register((stack, index) -> {
            ListTag tagList;
            if (index == 0) {
                CompoundTag logic = (CompoundTag)stack.get(FLDataComponents.CONNECTION_LOGIC);
                if (logic != null) {
                    return HangingLightsConnectionItem.getString(logic).getColor();
                }
                return ((StringType)StringTypes.BLACK_STRING.get()).getColor();
            }
            CompoundTag logic = (CompoundTag)stack.get(FLDataComponents.CONNECTION_LOGIC);
            if (logic != null && (tagList = logic.getList("pattern", 10)).size() > 0) {
                ClientLevel level = Minecraft.getInstance().level;
                Object registryAccess = level != null ? level.registryAccess() : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
                ItemStack item = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)tagList.getCompound((index - 1) % tagList.size())).orElse(ItemStack.EMPTY);
                if (ColorChangingBehavior.exists(item)) {
                    return ColorChangingBehavior.animate(item);
                }
                return DyeableItem.getColor(item);
            }
            if (FairyLights.CHRISTMAS.isOccurringNow()) {
                return ((long)index + Util.getMillis() / 2000L) % 2L == 0L ? 0x993333 : 8375321;
            }
            if (FairyLights.HALLOWEEN.isOccurringNow()) {
                return index % 2 == 0 ? 16351261 : 8991416;
            }
            return 16766340;
        }, new ItemLike[]{(ItemLike)FLItems.HANGING_LIGHTS.get()});
        event.register((stack, index) -> index == 0 ? DyeableItem.getColor(stack) : -1, new ItemLike[]{(ItemLike)FLItems.TINSEL.get()});
        event.register((stack, index) -> {
            ListTag tagList;
            if (index == 0) {
                return -1;
            }
            CompoundTag logic = (CompoundTag)stack.get(FLDataComponents.CONNECTION_LOGIC);
            if (logic != null && (tagList = logic.getList("pattern", 10)).size() > 0) {
                ClientLevel level = Minecraft.getInstance().level;
                RegistryAccess registryAccess = level != null ? level.registryAccess() : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
                ItemStack light = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)tagList.getCompound((index - 1) % tagList.size())).orElse(ItemStack.EMPTY);
                return DyeableItem.getColor(light);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)FLItems.PENNANT_BUNTING.get()});
        event.register(ClientProxy::secondLayerColor, new ItemLike[]{(ItemLike)FLItems.TRIANGLE_PENNANT.get()});
        event.register(ClientProxy::secondLayerColor, new ItemLike[]{(ItemLike)FLItems.SPEARHEAD_PENNANT.get()});
        event.register(ClientProxy::secondLayerColor, new ItemLike[]{(ItemLike)FLItems.SWALLOWTAIL_PENNANT.get()});
        event.register(ClientProxy::secondLayerColor, new ItemLike[]{(ItemLike)FLItems.SQUARE_PENNANT.get()});
        event.register((stack, index) -> {
            StyledString str;
            CompoundTag textTag;
            if (index > 0 && stack.has(FLDataComponents.STYLED_STRING) && (textTag = (CompoundTag)stack.get(FLDataComponents.STYLED_STRING)) != null && (str = StyledString.deserialize(textTag)).length() > 0) {
                ChatFormatting lastColor = null;
                ChatFormatting color = null;
                int n = (index - 1) % str.length();
                for (int i = 0; i < str.length() && (lastColor == (color = str.styleAt(i).getColor()) || n-- != 0); ++i) {
                    lastColor = color;
                }
                return StyledString.getColor(color) | 0xFF000000;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)FLItems.LETTER_BUNTING.get()});
    }

    private static int secondLayerColor(ItemStack stack, int index) {
        return index == 0 ? 0xFFFFFF : DyeableItem.getColor(stack);
    }
}

