/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import me.paulf.fairylights.client.ClientEventHandler;
import me.paulf.fairylights.client.midi.MidiJingler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JinglerCommand {
    private static final AtomicBoolean USED_COMMAND = new AtomicBoolean(false);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType NO_HANGING_LIGHTS = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.jingler.open.failure.no_hanging_lights"));
    private static final DynamicCommandExceptionType DEVICE_UNAVAILABLE = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.jingler.open.failure.device_unavailable", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType DEVICE_NOT_FOUND = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.jingler.open.failure.not_found", (Object[])new Object[]{name}));
    private static final SimpleCommandExceptionType CLOSE_FAILURE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.jingler.close.failure"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jingler").then(Commands.literal((String)"open").then(Commands.argument((String)"device", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> JinglerCommand.getDevices().reduce(builder, (b, device) -> b.suggest(device.getDeviceInfo().getName(), (Message)JinglerCommand.createDeviceText(device)), SuggestionsBuilder::add).buildFuture()).executes(ctx -> {
            Transmitter transmitter;
            Connection conn = ClientEventHandler.getHitConnection();
            if (!(conn instanceof HangingLightsConnection)) {
                throw NO_HANGING_LIGHTS.create();
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"device");
            MidiDevice device = JinglerCommand.getMidiDevice(name);
            try {
                transmitter = device.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                throw DEVICE_UNAVAILABLE.create((Object)name);
            }
            if (!device.isOpen()) {
                try {
                    device.open();
                }
                catch (MidiUnavailableException e) {
                    throw DEVICE_UNAVAILABLE.create((Object)name);
                }
            }
            transmitter.setReceiver(new MidiJingler((HangingLightsConnection)conn));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.jingler.open.success", (Object[])new Object[]{name}), false);
            USED_COMMAND.compareAndSet(false, true);
            return 1;
        })))).then(Commands.literal((String)"close").then(Commands.argument((String)"device", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> JinglerCommand.getDevices().filter(device -> device.getTransmitters().stream().anyMatch(t -> t.getReceiver() instanceof MidiJingler)).reduce(builder, (b, device) -> builder.suggest(device.getDeviceInfo().getName(), (Message)JinglerCommand.createDeviceText(device)), SuggestionsBuilder::add).buildFuture()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"device");
            MidiDevice device = JinglerCommand.getMidiDevice(name);
            int closed = JinglerCommand.close(device);
            if (closed == 0) {
                throw CLOSE_FAILURE.create();
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)(closed == 1 ? "commands.jingler.close.success.single" : "commands.jingler.close.success.multiple"), (Object[])new Object[]{closed}), false);
            return closed;
        }))));
    }

    private static MidiDevice getMidiDevice(String name) throws CommandSyntaxException {
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            if (!name.equals(info.getName())) continue;
            try {
                return MidiSystem.getMidiDevice(info);
            }
            catch (MidiUnavailableException e) {
                throw DEVICE_UNAVAILABLE.create((Object)name);
            }
        }
        throw DEVICE_NOT_FOUND.create((Object)name);
    }

    private static Stream<MidiDevice> getDevices() {
        Stream.Builder<MidiDevice> bob = Stream.builder();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            MidiDevice device;
            try {
                device = MidiSystem.getMidiDevice(info);
            }
            catch (IllegalArgumentException ignored) {
                continue;
            }
            catch (MidiUnavailableException e) {
                LOGGER.debug("Midi device unavailable: \"{}\", reason: \"{}\"", (Object)info.getName(), (Object)e.getMessage());
                continue;
            }
            if (device.getMaxTransmitters() == 0 || device instanceof Sequencer) continue;
            bob.accept(device);
        }
        return bob.build();
    }

    private static int close(MidiDevice device) {
        int closed = device.getTransmitters().stream().filter(t -> t.getReceiver() instanceof MidiJingler).reduce(0, (count, transmitter) -> {
            transmitter.close();
            return count + 1;
        }, Integer::sum);
        if (device.getTransmitters().isEmpty()) {
            device.close();
        }
        return closed;
    }

    private static Component createDeviceText(MidiDevice device) {
        MidiDevice.Info info = device.getDeviceInfo();
        return Component.translatable((String)"commands.jingler.device.vendor", (Object[])new Object[]{Component.literal((String)info.getVendor()).withStyle(ChatFormatting.GOLD)}).append("\n").append((Component)Component.translatable((String)"commands.jingler.device.description", (Object[])new Object[]{Component.literal((String)info.getDescription()).withStyle(ChatFormatting.GOLD)}));
    }

    public static void register(IEventBus bus) {
        bus.addListener(e -> {
            if (e.getLevel().isClientSide() && USED_COMMAND.compareAndSet(true, false)) {
                JinglerCommand.getDevices().forEach(JinglerCommand::close);
            }
        });
    }
}

