/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui;

import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.client.gui.component.PaletteButton;
import me.paulf.fairylights.client.gui.component.StyledTextFieldWidget;
import me.paulf.fairylights.client.gui.component.ToggleButton;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.serverbound.EditLetteredConnectionMessage;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public final class EditLetteredConnectionScreen<C extends Connection>
extends Screen {
    public static final ResourceLocation WIDGETS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"textures/gui/widgets.png");
    private final C connection;
    private StyledTextFieldWidget textField;
    private Button doneBtn;
    private Button cancelBtn;
    private ColorButton colorBtn;
    private ToggleButton boldBtn;
    private ToggleButton italicBtn;
    private ToggleButton underlineBtn;
    private ToggleButton strikethroughBtn;
    private PaletteButton paletteBtn;

    public EditLetteredConnectionScreen(C connection) {
        super((Component)Component.empty());
        this.connection = connection;
    }

    public void init() {
        int pad = 4;
        int buttonWidth = 150;
        this.doneBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), b -> {
            PacketDistributor.sendToServer(new EditLetteredConnectionMessage<C>(this.connection, this.textField.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }).pos(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12).size(150, 20).build());
        this.cancelBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).pos(this.width / 2 + 4, this.height / 4 + 120 + 12).size(150, 20).build());
        int textFieldX = this.width / 2 - 150;
        int textFieldY = this.height / 2 - 10;
        int buttonX = textFieldX;
        int buttonY = textFieldY - 25;
        int bInc = 24;
        this.colorBtn = (ColorButton)this.addRenderableWidget((GuiEventListener)new ColorButton(buttonX, buttonY, (Component)Component.empty(), b -> {
            this.paletteBtn.visible = !this.paletteBtn.visible;
        }));
        this.paletteBtn = (PaletteButton)this.addRenderableWidget((GuiEventListener)new PaletteButton(buttonX - 4, buttonY - 30, this.colorBtn, (Component)Component.translatable((String)"fairylights.color"), b -> this.textField.updateStyling(this.colorBtn.getDisplayColor(), true)));
        this.boldBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 40, 0, (Component)Component.empty(), b -> this.updateStyleButton(ChatFormatting.BOLD, this.boldBtn)));
        this.italicBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 60, 0, (Component)Component.empty(), b -> this.updateStyleButton(ChatFormatting.ITALIC, this.italicBtn)));
        this.underlineBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 80, 0, (Component)Component.empty(), b -> this.updateStyleButton(ChatFormatting.UNDERLINE, this.underlineBtn)));
        this.strikethroughBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 100, 0, (Component)Component.empty(), b -> this.updateStyleButton(ChatFormatting.STRIKETHROUGH, this.strikethroughBtn)));
        this.textField = new StyledTextFieldWidget(this.font, this.colorBtn, this.boldBtn, this.italicBtn, this.underlineBtn, this.strikethroughBtn, textFieldX, textFieldY, 300, 20, (Component)Component.translatable((String)"fairylights.letteredText"));
        this.textField.setValue(((Lettered)this.connection).getText());
        this.textField.setCaretStart();
        this.textField.setIsBlurable(false);
        this.textField.registerChangeListener(this::validateText);
        this.textField.setCharInputTransformer(((Lettered)this.connection).getInputTransformer());
        this.textField.setFocused(true);
        this.addWidget((GuiEventListener)this.textField);
        this.paletteBtn.visible = false;
        StylingPresence ss = ((Lettered)this.connection).getSupportedStyling();
        this.colorBtn.visible = ss.hasColor();
        this.boldBtn.visible = ss.hasBold();
        this.italicBtn.visible = ss.hasItalic();
        this.underlineBtn.visible = ss.hasUnderline();
        this.strikethroughBtn.visible = ss.hasStrikethrough();
        this.setInitialFocus((GuiEventListener)this.textField);
    }

    private void validateText(StyledString text) {
        this.doneBtn.active = ((Lettered)this.connection).isSupportedText(text) && !((Lettered)this.connection).getText().equals(text);
    }

    public void mouseMoved(double x, double y) {
        this.textField.mouseMoved(x, y);
    }

    public void tick() {
        this.textField.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.paletteBtn.visible = false;
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 66)) {
            this.toggleStyleButton(ChatFormatting.BOLD, this.boldBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 73)) {
            this.toggleStyleButton(ChatFormatting.ITALIC, this.italicBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 85)) {
            this.toggleStyleButton(ChatFormatting.UNDERLINE, this.underlineBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 83)) {
            this.toggleStyleButton(ChatFormatting.STRIKETHROUGH, this.strikethroughBtn);
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.doneBtn.active) {
            this.doneBtn.onPress();
            return true;
        }
        if (keyCode == 256) {
            this.cancelBtn.onPress();
            return true;
        }
        return false;
    }

    private void toggleStyleButton(ChatFormatting styling, ToggleButton btn) {
        btn.setValue(!btn.getValue());
        this.updateStyleButton(styling, btn);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        this.paletteBtn.visible = false;
        return false;
    }

    private void updateStyleButton(ChatFormatting styling, ToggleButton btn) {
        if (btn.visible) {
            this.textField.updateStyling(styling, btn.getValue());
        }
    }

    public void render(GuiGraphics stack, int mouseX, int mouseY, float delta) {
        this.renderBackground(stack, mouseX, mouseY, delta);
        stack.drawCenteredString(this.font, (Component)Component.translatable((String)"fairylights.editLetteredConnection"), this.width / 2, 20, 0xFFFFFF);
        super.render(stack, mouseX, mouseY, delta);
        this.textField.render(stack, mouseX, mouseY, delta);
        String allowed = ((Lettered)this.connection).getAllowedDescription();
        if (!allowed.isEmpty()) {
            stack.drawString(this.font, (Component)Component.translatable((String)"fairylights.editLetteredConnection.allowed_characters", (Object[])new Object[]{allowed}).withStyle(ChatFormatting.GRAY), this.textField.getX(), this.textField.getY() + 24, -1);
        }
    }

    public static boolean isControlOp(int key, int controlKey) {
        return key == controlKey && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }
}

