/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public final class ColorButton
extends Button {
    private static final int TEX_U = 0;
    private static final int TEX_V = 0;
    private ChatFormatting displayColor;
    private float displayColorR;
    private float displayColorG;
    private float displayColorB;

    public ColorButton(int x, int y, Component msg, Button.OnPress onPress) {
        super(x, y, 20, 20, msg, onPress, DEFAULT_NARRATION);
    }

    public void setDisplayColor(ChatFormatting color) {
        this.displayColor = color;
        int rgb = StyledString.getColor(color);
        this.displayColorR = (float)(rgb >> 16 & 0xFF) / 255.0f;
        this.displayColorG = (float)(rgb >> 8 & 0xFF) / 255.0f;
        this.displayColorB = (float)(rgb & 0xFF) / 255.0f;
    }

    public ChatFormatting getDisplayColor() {
        return this.displayColor;
    }

    public void removeDisplayColor() {
        this.displayColor = null;
    }

    public boolean hasDisplayColor() {
        return this.displayColor != null;
    }

    public void renderWidget(GuiGraphics stack, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.blit(EditLetteredConnectionScreen.WIDGETS_TEXTURE, this.getX(), this.getY(), 0, this.isHovered ? 0 + this.height : 0, this.width, this.height);
            if (this.displayColor != null) {
                stack.blit(EditLetteredConnectionScreen.WIDGETS_TEXTURE, this.getX(), this.getY(), 0 + this.width, 0, this.width, this.height);
                RenderSystem.setShaderColor((float)this.displayColorR, (float)this.displayColorG, (float)this.displayColorB, (float)1.0f);
                stack.blit(EditLetteredConnectionScreen.WIDGETS_TEXTURE, this.getX(), this.getY(), 0 + this.width, 0 + this.height, this.width, this.height);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

