/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class IncandescentLightModel
extends LightModel<BrightnessLightBehavior> {
    final ModelPart bulb;
    final ModelPart filament;

    public IncandescentLightModel(ModelPart root) {
        super(root);
        this.bulb = root.getChild("bulb");
        this.filament = root.getChild("filament");
    }

    @Override
    public void animate(Light<?> light, BrightnessLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.brightness = behavior.getBrightness(delta);
    }

    @Override
    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    @Override
    public void renderToBuffer(PoseStack matrix, VertexConsumer builder, int light, int overlay, int packedColor) {
        float r = (float)(packedColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedColor & 0xFF) / 255.0f;
        float a = (float)(packedColor >> 24 & 0xFF) / 255.0f;
        super.renderToBuffer(matrix, builder, light, overlay, packedColor);
        int emissiveLight = this.getLight(light);
        float cr = 0.23f;
        float cg = 0.18f;
        float cb = 0.14f;
        float br = this.brightness;
        float finalR = r * (0.23f * (1.0f - br) + br);
        float finalG = g * (0.18f * (1.0f - br) + br);
        float finalB = b * (0.14f * (1.0f - br) + br);
        int filamentColor = (int)(finalR * 255.0f) << 16 | (int)(finalG * 255.0f) << 8 | (int)(finalB * 255.0f) | (int)(a * 255.0f) << 24;
        this.filament.render(matrix, builder, emissiveLight, overlay, filamentColor);
    }

    @Override
    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        float bi = this.brightness;
        int emissiveLight = this.getLight(light);
        float br = 1.0f;
        float bg = 0.73f;
        float bb = 0.3f;
        float finalR = r * (1.0f * bi + (1.0f - bi));
        float finalG = g * (0.73f * bi + (1.0f - bi));
        float finalB = b * (0.3f * bi + (1.0f - bi));
        float finalA = bi * 0.4f + 0.25f;
        int bulbColor = (int)(finalR * 255.0f) << 16 | (int)(finalG * 255.0f) << 8 | (int)(finalB * 255.0f) | (int)(finalA * 255.0f) << 24;
        this.bulb.render(matrix, builder, emissiveLight, overlay, bulbColor);
        super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
    }

    public static LayerDefinition createLayer() {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        helper.unlit().setTextureOffset(90, 10);
        helper.unlit().addBox(-1.0f, -0.01f, -1.0f, 2.0f, 1.0f, 2.0f);
        EasyMeshBuilder bulb = new EasyMeshBuilder("bulb", 98, 10);
        bulb.addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        helper.extra().add(bulb);
        EasyMeshBuilder filament = new EasyMeshBuilder("filament", 90, 13);
        filament.addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f);
        helper.extra().add(filament);
        return helper.build();
    }
}

