/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.util.AABBBuilder;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public abstract class LightModel<T extends LightBehavior>
extends Model {
    protected final ModelPart lit;
    protected final ModelPart litTint;
    protected final ModelPart litTintGlow;
    protected final ModelPart unlit;
    protected float brightness = 1.0f;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    @Nullable
    private AABB bounds;
    private double floorOffset = Double.NaN;
    private boolean powered;

    public LightModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.lit = root.getChild("lit");
        this.litTint = root.getChild("lit_tint");
        this.litTintGlow = root.getChild("lit_tint_glow");
        this.unlit = root.getChild("unlit");
    }

    public AABB getBounds() {
        if (this.bounds == null) {
            PoseStack matrix = new PoseStack();
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.renderToBuffer(matrix, builder, 0, 0, -1);
            this.renderTranslucent(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.bounds = builder.build();
        }
        return this.bounds;
    }

    public double getFloorOffset() {
        if (Double.isNaN(this.floorOffset)) {
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.renderToBuffer(new PoseStack(), builder, 0, 0, -1);
            this.floorOffset = builder.build().minY - this.getBounds().minY;
        }
        return this.floorOffset;
    }

    public void animate(Light<?> light, T behavior, float delta) {
        this.powered = light.isPowered();
    }

    public void renderToBuffer(PoseStack matrix, VertexConsumer builder, int light, int overlay, int packedColor) {
        float r = (float)(packedColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedColor & 0xFF) / 255.0f;
        float a = (float)(packedColor >> 24 & 0xFF) / 255.0f;
        this.unlit.render(matrix, builder, light, overlay, packedColor);
        int emissiveLight = this.getLight(light);
        int litColor = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) | (int)(a * 255.0f) << 24;
        this.lit.render(matrix, builder, emissiveLight, overlay, litColor);
        int tintColor = (int)(r * this.red * 255.0f) << 16 | (int)(g * this.green * 255.0f) << 8 | (int)(b * this.blue * 255.0f) | (int)(a * 255.0f) << 24;
        this.litTint.render(matrix, builder, emissiveLight, overlay, tintColor);
    }

    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        float v = this.brightness;
        float finalR = r * this.red * v + (1.0f - v);
        float finalG = g * this.green * v + (1.0f - v);
        float finalB = b * this.blue * v + (1.0f - v);
        float finalA = v * 0.15f + 0.2f;
        int packedColor = (int)(finalR * 255.0f) << 16 | (int)(finalG * 255.0f) << 8 | (int)(finalB * 255.0f) | (int)(finalA * 255.0f) << 24;
        this.litTintGlow.render(matrix, builder, this.getLight(light), overlay, packedColor);
    }

    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, this.powered ? 0.0f : (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    protected static float[] toEuler(Quaternionf q) {
        float r11 = 2.0f * (q.x() * q.y() + q.w() * q.z());
        float r12 = q.w() * q.w() + q.x() * q.x() - q.y() * q.y() - q.z() * q.z();
        float r21 = -2.0f * (q.x() * q.z() - q.w() * q.y());
        float r31 = 2.0f * (q.y() * q.z() + q.w() * q.x());
        float r32 = q.w() * q.w() - q.x() * q.x() - q.y() * q.y() + q.z() * q.z();
        return new float[]{(float)Mth.atan2((double)r31, (double)r32), (float)Math.asin(r21), (float)Mth.atan2((double)r11, (double)r12)};
    }

    static class AABBVertexBuilder
    implements VertexConsumer {
        final AABBBuilder builder = new AABBBuilder();

        AABBVertexBuilder() {
        }

        public VertexConsumer addVertex(double x, double y, double z) {
            this.builder.include(x, y, z);
            return this;
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            this.builder.include(x, y, z);
            return this;
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            return this;
        }

        public VertexConsumer setUv(float u, float v) {
            return this;
        }

        public VertexConsumer setUv1(int u, int v) {
            return this;
        }

        public VertexConsumer setUv2(int u, int v) {
            return this;
        }

        public VertexConsumer setOverlay(int u, int v) {
            return this;
        }

        public VertexConsumer setLight(int uv) {
            return this;
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            return this;
        }

        AABB build() {
            return this.builder.build();
        }
    }

    static interface ModelPartFactory {
        public EasyMeshBuilder create(String var1, int var2, int var3);
    }

    static class BulbBuilder {
        EasyMeshBuilder base;
        EasyMeshBuilder glow;

        public BulbBuilder(EasyMeshBuilder base, EasyMeshBuilder glow) {
            this.base = base;
            this.glow = glow;
        }

        public BulbBuilder setUV(int u, int v) {
            this.base.setTextureOffset(u, v);
            this.glow.setTextureOffset(u, v);
            return this;
        }

        void addBox(float x, float y, float z, float width, float height, float depth) {
            this.addBox(x, y, z, width, height, depth, 0.0f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand) {
            this.addBox(x, y, z, width, height, depth, expand, 0.7f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand, float glow) {
            this.base.addBox(x, y, z, width, height, depth, expand);
            this.glow.addBox(x, y, z, width, height, depth, expand + glow);
        }

        BulbBuilder createChild(String name, int u, int v) {
            return this.createChild(name, u, v, EasyMeshBuilder::new);
        }

        BulbBuilder createChild(String name, int u, int v, ModelPartFactory factory) {
            EasyMeshBuilder base = factory.create(name, u, v);
            EasyMeshBuilder glow = factory.create(name, u, v);
            this.base.addChild(base);
            this.glow.addChild(glow);
            return new BulbBuilder(base, glow);
        }

        public void setPosition(float x, float y, float z) {
            this.base.setRotationPoint(x, y, z);
            this.glow.setRotationPoint(x, y, z);
        }

        public void setAngles(float x, float y, float z) {
            this.base.xRot = x;
            this.base.yRot = y;
            this.base.zRot = z;
            this.glow.xRot = x;
            this.glow.yRot = y;
            this.glow.zRot = z;
        }
    }

    public record LightMeshHelper(EasyMeshBuilder lit, EasyMeshBuilder litTint, EasyMeshBuilder litTintGlow, EasyMeshBuilder unlit, List<EasyMeshBuilder> extra) {
        public BulbBuilder createBulb() {
            return new BulbBuilder(this.litTint(), this.litTintGlow());
        }

        public LayerDefinition build() {
            MeshDefinition def = new MeshDefinition();
            this.lit().build(def.getRoot());
            this.litTint().build(def.getRoot());
            this.litTintGlow().build(def.getRoot());
            this.unlit().build(def.getRoot());
            for (EasyMeshBuilder builder : this.extra()) {
                builder.build(def.getRoot());
            }
            return LayerDefinition.create((MeshDefinition)def, (int)128, (int)128);
        }

        public EasyMeshBuilder parented(String name) {
            EasyMeshBuilder result = new EasyMeshBuilder(name);
            result.addChild(this.lit());
            result.addChild(this.litTint());
            result.addChild(this.litTintGlow());
            result.addChild(this.unlit());
            for (EasyMeshBuilder builder : this.extra()) {
                result.addChild(builder);
            }
            return result;
        }

        public static LightMeshHelper create() {
            EasyMeshBuilder lit = new EasyMeshBuilder("lit");
            EasyMeshBuilder litTint = new EasyMeshBuilder("lit_tint");
            EasyMeshBuilder litTintGlow = new EasyMeshBuilder("lit_tint_glow");
            EasyMeshBuilder unlit = new EasyMeshBuilder("unlit");
            return new LightMeshHelper(lit, litTint, litTintGlow, unlit, new ArrayList<EasyMeshBuilder>());
        }
    }
}

