/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.MeteorLightBehavior;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.util.Mth;

public class MeteorLightModel
extends LightModel<MeteorLightBehavior> {
    private static final int LIGHT_COUNT = 12;
    private final PartPair[] lights;
    private final ModelPart connector;
    private final ModelPart cap;
    private float stage;

    public MeteorLightModel(ModelPart root) {
        super(root);
        this.connector = this.unlit.getChild("connector");
        this.cap = this.unlit.getChild("cap");
        this.lights = new PartPair[12];
        for (int i = 0; i < 12; ++i) {
            String key = "light_" + i;
            this.lights[i] = new PartPair(this.litTint.getChild(key), this.litTintGlow.getChild(key));
        }
    }

    @Override
    public void animate(Light<?> light, MeteorLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.red = behavior.getRed(delta);
        this.green = behavior.getGreen(delta);
        this.blue = behavior.getBlue(delta);
        this.stage = behavior.getProgress(delta) * 3.0f - 1.0f;
    }

    private float computeBrightness(float t) {
        return Mth.clamp((float)(t - this.stage > 0.0f ? 1.0f - Math.abs(t - this.stage) * 4.0f : 1.0f - Math.abs(t - this.stage)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void renderToBuffer(PoseStack matrix, VertexConsumer builder, int light, int overlay, int packedColor) {
        float r = (float)(packedColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedColor & 0xFF) / 255.0f;
        float a = (float)(packedColor >> 24 & 0xFF) / 255.0f;
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            this.connector.visible = i == 0;
            this.cap.visible = i == this.lights.length - 1;
            super.renderToBuffer(matrix, builder, light, overlay, packedColor);
        }
    }

    @Override
    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
        }
    }

    public static LayerDefinition createLayer() {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        EasyMeshBuilder connector = new EasyMeshBuilder("connector", 77, 0);
        connector.addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, -0.05f);
        helper.unlit().addChild(connector);
        EasyMeshBuilder cap = new EasyMeshBuilder("cap", 77, 0);
        cap.addBox(-1.0f, -25.400002f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f);
        helper.unlit().addChild(cap);
        float rodScale = 0.8f;
        LightModel.BulbBuilder bulb = helper.createBulb();
        for (int i = 0; i < 12; ++i) {
            LightModel.BulbBuilder light = bulb.createChild("light_" + i, 37, 72);
            light.addBox(-1.0f, (float)(-i * 2) - 2.5f + 0.05f, -1.0f, 2.0f, 2.0f, 2.0f, Mth.sin((float)((float)i * (float)Math.PI / 12.0f)) * 0.1f);
        }
        return helper.build();
    }

    private record PartPair(ModelPart first, ModelPart second) {
        void setVisible(boolean visible) {
            this.first().visible = visible;
            this.second().visible = visible;
        }
    }
}

