/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.net;

import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.net.ClientMessageContext;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.clientbound.JingleMessage;
import me.paulf.fairylights.server.net.clientbound.OpenEditLetteredConnectionScreenMessage;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ClientMessageHandlers {
    public static void handleOpenScreen(OpenEditLetteredConnectionScreenMessage<?> message, ClientMessageContext context) {
        ConnectionMessage.getConnection(message, c -> c instanceof Lettered, (Level)Minecraft.getInstance().level).ifPresent(connection -> Minecraft.getInstance().setScreen(new EditLetteredConnectionScreen<Connection>((Connection)((Object)((Lettered)((Object)connection))))));
    }

    public static void handleJingle(JingleMessage message, ClientMessageContext context) {
        Jingle jingle = message.jingle;
        if (jingle != null) {
            ConnectionMessage.getConnection(message, c -> c instanceof HangingLightsConnection, (Level)Minecraft.getInstance().level).ifPresent(connection -> connection.play(jingle, message.getLightOffset()));
        }
    }

    public static void handleUpdateEntityFastener(UpdateEntityFastenerMessage message, ClientMessageContext context) {
        Entity entity = Minecraft.getInstance().level.getEntity(message.getEntityId());
        if (entity != null) {
            CapabilityHandler.getFastenerCapability(entity).ifPresent(fastener -> fastener.deserializeNBT(message.getCompound(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        }
    }
}

