/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.util.Curve;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public abstract class ConnectionRenderer<C extends Connection> {
    private final WireModel model;
    private final float wireInflate;

    protected ConnectionRenderer(Function<ModelLayerLocation, ModelPart> baker, ModelLayerLocation wireModelLocation) {
        this(baker, wireModelLocation, 0.0f);
    }

    protected ConnectionRenderer(Function<ModelLayerLocation, ModelPart> baker, ModelLayerLocation wireModelLocation, float wireInflate) {
        this.model = new WireModel(baker.apply(wireModelLocation));
        this.wireInflate = wireInflate;
    }

    public void render(C conn, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        Curve currCat = ((Connection)conn).getCatenary();
        Curve prevCat = ((Connection)conn).getPrevCatenary();
        if (currCat != null && prevCat != null) {
            Curve cat = prevCat.lerp(currCat, delta);
            Curve.SegmentIterator it = cat.iterator();
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.buffer(source, RenderType::entityCutout);
            int color = this.getWireColor(conn);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            while (it.next()) {
                matrix.pushPose();
                double depthOffset = 0.01;
                matrix.translate((double)it.getX(0.0f) + 0.01, (double)it.getY(0.0f) + 0.01, (double)it.getZ(0.0f) + 0.01);
                matrix.mulPose(Axis.YP.rotation(1.5707964f - it.getYaw()));
                matrix.mulPose(Axis.XP.rotation(-it.getPitch()));
                matrix.scale(1.0f + this.wireInflate, 1.0f, it.getLength() * 16.0f);
                int packedColor = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) | 0xFF000000;
                this.model.renderToBuffer(matrix, buf, packedLight, packedOverlay, packedColor);
                matrix.popPose();
                this.renderSegment(conn, it, delta, matrix, packedLight, source, packedOverlay);
            }
            this.render(conn, cat, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    protected int getWireColor(C conn) {
        return 0xFFFFFF;
    }

    protected void render(C conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
    }

    protected void renderSegment(C connection, Curve.SegmentView it, float delta, PoseStack matrix, int packedLight, MultiBufferSource source, int packedOverlay) {
    }

    public static class WireModel
    extends Model {
        final ModelPart root;

        WireModel(ModelPart root) {
            super(RenderType::entityCutout);
            this.root = root;
        }

        public void renderToBuffer(PoseStack matrix, VertexConsumer builder, int light, int overlay, int packedColor) {
            this.root.render(matrix, builder, light, overlay, packedColor);
        }

        public static LayerDefinition createLayer(int u, int v, int size) {
            MeshDefinition mesh = new MeshDefinition();
            mesh.getRoot().addOrReplaceChild("root", CubeListBuilder.create().texOffs(u, v).addBox((float)(-size) * 0.5f, (float)(-size) * 0.5f, 0.0f, (float)size, (float)size, 1.0f), PartPose.ZERO);
            return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
        }
    }
}

