/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.UUID;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientEventHandler;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.model.light.BowModel;
import me.paulf.fairylights.client.renderer.block.entity.GarlandTinselRenderer;
import me.paulf.fairylights.client.renderer.block.entity.GarlandVineRenderer;
import me.paulf.fairylights.client.renderer.block.entity.HangingLightsRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LetterBuntingRenderer;
import me.paulf.fairylights.client.renderer.block.entity.PennantBuntingRenderer;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FenceFastener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class FastenerRenderer {
    private final HangingLightsRenderer hangingLights;
    private final GarlandVineRenderer garland;
    private final GarlandTinselRenderer tinsel;
    private final PennantBuntingRenderer pennants;
    private final LetterBuntingRenderer letters;
    private final BowModel bow;

    public FastenerRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        this.hangingLights = new HangingLightsRenderer(baker);
        this.garland = new GarlandVineRenderer(baker);
        this.tinsel = new GarlandTinselRenderer(baker);
        this.pennants = new PennantBuntingRenderer(baker);
        this.letters = new LetterBuntingRenderer(baker);
        this.bow = new BowModel(baker.apply(FLModelLayers.BOW));
    }

    public void render(Fastener<?> fastener, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        boolean renderBow = true;
        for (Connection conn : fastener.getAllConnections()) {
            boolean isOrigin;
            UUID uuid = conn.getUUID();
            boolean bl = isOrigin = conn.getFastener() == fastener;
            if (ClientEventHandler.RENDERED_CONNECTIONS.add(uuid)) {
                matrix.pushPose();
                if (!isOrigin) {
                    Vec3 origin = conn.getFastener().getConnectionPoint();
                    Vec3 dest = fastener.getConnectionPoint();
                    matrix.translate(origin.x - dest.x, origin.y - dest.y, origin.z - dest.z);
                    System.out.println("FL_DEBUG: Rendering connection " + String.valueOf(uuid) + " (as Destination)");
                } else {
                    System.out.println("FL_DEBUG: Rendering connection " + String.valueOf(uuid) + " (as Origin)");
                }
                this.renderConnection(delta, matrix, source, packedLight, packedOverlay, conn);
                matrix.popPose();
            }
            if (!renderBow || !(conn instanceof GarlandVineConnection) || !this.renderBow(fastener, matrix, source, packedLight, packedOverlay)) continue;
            renderBow = false;
        }
    }

    private boolean renderBow(Fastener<?> fastener, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        if (fastener instanceof FenceFastener) {
            Level world = fastener.getWorld();
            if (world == null) {
                return false;
            }
            BlockState state = world.getBlockState(fastener.getPos());
            if (!state.is(Tags.Blocks.FENCES)) {
                return false;
            }
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.buffer(source, RenderType::entityCutout);
            float offset = -0.09375f;
            boolean north = (Boolean)state.getValue((Property)FenceBlock.NORTH);
            boolean east = (Boolean)state.getValue((Property)FenceBlock.EAST);
            boolean south = (Boolean)state.getValue((Property)FenceBlock.SOUTH);
            boolean west = (Boolean)state.getValue((Property)FenceBlock.WEST);
            boolean tryDirX = true;
            boolean bow = false;
            if (!north && (east || west)) {
                this.bow(matrix, Direction.NORTH, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (!south && (east || west)) {
                this.bow(matrix, Direction.SOUTH, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (tryDirX) {
                if (!east && (north || south)) {
                    this.bow(matrix, Direction.EAST, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
                if (!west && (north || south)) {
                    this.bow(matrix, Direction.WEST, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
            }
            return bow;
        }
        if (fastener.getFacing().getAxis() != Direction.Axis.Y) {
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.buffer(source, RenderType::entityCutout);
            this.bow(matrix, fastener.getFacing(), 0.0f, buf, packedLight, packedOverlay);
            return true;
        }
        return false;
    }

    private void bow(PoseStack matrix, Direction dir, float offset, VertexConsumer buf, int packedLight, int packedOverlay) {
        matrix.pushPose();
        matrix.mulPose(Axis.YP.rotationDegrees(180.0f - dir.toYRot()));
        if (offset != 0.0f) {
            matrix.translate(0.0, 0.0, (double)offset);
        }
        this.bow.renderToBuffer(matrix, buf, packedLight, packedOverlay, -1);
        matrix.popPose();
    }

    private void renderConnection(float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay, Connection conn) {
        if (conn instanceof HangingLightsConnection) {
            this.hangingLights.render((HangingLightsConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandVineConnection) {
            this.garland.render((GarlandVineConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandTinselConnection) {
            this.tinsel.render((GarlandTinselConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof PennantBuntingConnection) {
            this.pennants.render((PennantBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof LetterBuntingConnection) {
            this.letters.render((LetterBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    public static void renderBakedModel(ResourceLocation path, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        ModelResourceLocation modelLoc = new ModelResourceLocation(path, "inventory");
        FastenerRenderer.renderBakedModel(Minecraft.getInstance().getModelManager().getModel(modelLoc), matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(BakedModel model, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(model, ItemDisplayContext.FIXED, matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(BakedModel model, ItemDisplayContext type, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        model.getTransforms().getTransform(type).apply(false, matrix);
        PoseStack.Pose lastStack = matrix.last();
        RandomSource randSource = RandomSource.create();
    }
}

