/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.RandomArray;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class GarlandVineRenderer
extends ConnectionRenderer<GarlandVineConnection> {
    private static final int RING_COUNT = 7;
    private static final RandomArray RAND = new RandomArray(8411L, 28);
    private final RingsModel rings;

    protected GarlandVineRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.VINE_WIRE);
        this.rings = new RingsModel(baker.apply(FLModelLayers.GARLAND_RINGS));
    }

    @Override
    protected void render(GarlandVineConnection conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        int hash = conn.getUUID().hashCode();
        VertexConsumer buf = ClientProxy.SOLID_TEXTURE.buffer(source, RenderType::entityCutout);
        catenary.visitPoints(0.25f, false, (index, x, y, z, yaw, pitch) -> {
            matrix.pushPose();
            double depthOffset = 0.01;
            matrix.translate((double)x + 0.01, (double)y + 0.01, (double)z + 0.01);
            matrix.mulPose(Axis.YP.rotation(-yaw));
            matrix.mulPose(Axis.ZP.rotation(pitch));
            matrix.mulPose(Axis.ZP.rotationDegrees(RAND.get(index + hash) * 45.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(RAND.get(index + 8 + hash) * 60.0f + 90.0f));
            this.rings.setWhich(index % 7);
            this.rings.renderToBuffer(matrix, buf, packedLight, packedOverlay, -1);
            matrix.popPose();
        });
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(39, 0, 1);
    }

    public static class RingsModel
    extends Model {
        final ModelPart[] roots;
        int which;

        RingsModel(ModelPart root) {
            super(RenderType::entityCutout);
            ModelPart[] roots = new ModelPart[7];
            for (int i = 0; i < 7; ++i) {
                roots[i] = root.getChild(Integer.toString(i));
            }
            this.roots = roots;
        }

        public static LayerDefinition createLayer() {
            float size = 4.0f;
            CubeListBuilder root = CubeListBuilder.create().texOffs(14, 91).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f);
            PartPose crossPose = PartPose.rotation((float)0.0f, (float)0.0f, (float)1.5707964f);
            MeshDefinition mesh = new MeshDefinition();
            for (int i = 0; i < 7; ++i) {
                mesh.getRoot().addOrReplaceChild(Integer.toString(i), root, PartPose.ZERO).addOrReplaceChild("cross_" + i, CubeListBuilder.create().texOffs(i * 8, 64).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f), crossPose);
            }
            return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
        }

        public void setWhich(int which) {
            this.which = which;
        }

        public void renderToBuffer(PoseStack matrix, VertexConsumer builder, int light, int overlay, int packedColor) {
            this.roots[this.which].render(matrix, builder, light, overlay, packedColor);
        }
    }
}

