/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.client.renderer.block.entity.LightRenderer;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LightBlockEntityRenderer
implements BlockEntityRenderer<LightBlockEntity> {
    private final LightRenderer lights = new LightRenderer(arg_0 -> ((BlockEntityRendererProvider.Context)context).bakeLayer(arg_0));

    public LightBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(LightBlockEntity entity) {
        return true;
    }

    public void render(LightBlockEntity entity, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        this.render(entity, delta, matrix, source, packedLight, packedOverlay, entity.getLight());
    }

    private <T extends LightBehavior> void render(LightBlockEntity entity, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay, Light<T> light) {
        LightModel model = this.lights.getModel(light, -1);
        AABB box = model.getBounds();
        BlockState state = entity.getBlockState();
        AttachFace face = (AttachFace)state.getValue((Property)LightBlock.FACE);
        float rotation = ((Direction)state.getValue((Property)LightBlock.FACING)).toYRot();
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        matrix.mulPose(Axis.YP.rotationDegrees(180.0f - rotation));
        if (light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            } else if (face == AttachFace.FLOOR) {
                matrix.mulPose(Axis.XP.rotationDegrees(-180.0f));
            }
            matrix.translate(0.0, 0.5, 0.0);
        } else if (face == AttachFace.CEILING) {
            matrix.translate(0.0, 0.25, 0.0);
        } else if (face == AttachFace.WALL) {
            matrix.translate(0.0, 0.1875, 0.125);
        } else {
            matrix.translate(0.0, -box.minY - model.getFloorOffset() - 0.5, 0.0);
        }
        this.lights.render(matrix, this.lights.start(source), light, model, delta, packedLight, packedOverlay);
        matrix.popPose();
    }
}

