/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;

public final class FenceFastenerRenderer
extends EntityRenderer<FenceFastenerEntity> {
    public static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"block/fence_fastener");
    private final FastenerRenderer renderer = new FastenerRenderer(arg_0 -> ((EntityRendererProvider.Context)context).bakeLayer(arg_0));

    public FenceFastenerRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(FenceFastenerEntity entity, Frustum frustum, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(FenceFastenerEntity entity, BlockPos delta) {
        return entity.level().getBrightness(LightLayer.BLOCK, entity.blockPosition());
    }

    public void render(FenceFastenerEntity entity, float yaw, float delta, PoseStack matrix, MultiBufferSource source, int packedLight) {
        VertexConsumer buf = source.getBuffer(Sheets.cutoutBlockSheet());
        matrix.pushPose();
        FastenerRenderer.renderBakedModel(MODEL, matrix, buf, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        matrix.popPose();
        entity.getFastener().ifPresent(f -> this.renderer.render((Fastener<?>)f, delta, matrix, source, packedLight, OverlayTexture.NO_OVERLAY));
        super.render((Entity)entity, yaw, delta, matrix, source, packedLight);
    }

    public ResourceLocation getTextureLocation(FenceFastenerEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

