/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.tutorial;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.FLClientConfig;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.LazyItemStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;

public class ClippyController {
    private final ImmutableMap<String, Supplier<State>> states = (ImmutableMap)Stream.of(NoProgressState::new, CraftHangingLightsState::new, CompleteState::new).collect(ImmutableMap.toImmutableMap(s -> ((State)s.get()).name(), Function.identity()));
    private State state = new NoProgressState();

    public void init(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getLevel() instanceof ClientLevel) {
                this.reload();
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)patt0$temp;
                Minecraft mc = Minecraft.getInstance();
                if (!mc.isPaused() && mc.player != null) {
                    this.state.tick(player, this);
                }
            }
        });
        modBus.addListener(e -> {
            if (e.getConfig().getSpec() == FLClientConfig.SPEC && Minecraft.getInstance().player != null) {
                this.reload();
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            this.reload();
            this.state.tick(e.getPlayer(), this);
        });
    }

    private void reload() {
        try {
            String progressValue = (String)FLClientConfig.TUTORIAL.progress.get();
            this.setState((State)((Supplier)this.states.getOrDefault((Object)progressValue, NoProgressState::new)).get());
        }
        catch (IllegalStateException | NullPointerException e) {
            this.setState(new NoProgressState());
        }
    }

    private void setState(State state) {
        this.state.stop();
        this.state = state;
        this.state.start();
        try {
            FLClientConfig.TUTORIAL.progress.set((Object)this.state.name());
            FLClientConfig.TUTORIAL.progress.save();
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    static class NoProgressState
    implements State {
        NoProgressState() {
        }

        @Override
        public String name() {
            return "none";
        }

        @Override
        public void tick(LocalPlayer player, ClippyController controller) {
            if (player.getInventory().contains(FLCraftingRecipes.LIGHTS)) {
                controller.setState(new CraftHangingLightsState());
            }
        }
    }

    static interface State {
        public String name();

        default public void start() {
        }

        default public void tick(LocalPlayer player, ClippyController controller) {
        }

        default public void stop() {
        }
    }

    static class Balloon
    implements Toast {
        final LazyItemStack stack;
        final Component title;
        @Nullable
        final Component subtitle;
        Toast.Visibility visibility;

        Balloon(LazyItemStack stack, Component title, @Nullable Component subtitle) {
            this.stack = stack;
            this.title = title;
            this.subtitle = subtitle;
            this.visibility = Toast.Visibility.SHOW;
        }

        void hide() {
            this.visibility = Toast.Visibility.HIDE;
        }

        public Toast.Visibility render(GuiGraphics stack, ToastComponent toastGui, long delta) {
            if (delta > 5000L) {
                this.hide();
                return Toast.Visibility.HIDE;
            }
            ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
            stack.blitSprite(TEXTURE, 0, 0, 160, 32);
            stack.renderFakeItem(this.stack.get(), 8, 8);
            if (this.subtitle == null) {
                stack.drawString(toastGui.getMinecraft().font, this.title, 30, 12, -11534256);
            } else {
                stack.drawString(toastGui.getMinecraft().font, this.title, 30, 7, -11534256);
                stack.drawString(toastGui.getMinecraft().font, this.subtitle, 30, 18, -16777216);
            }
            return this.visibility;
        }
    }

    static class CompleteState
    implements State {
        CompleteState() {
        }

        @Override
        public String name() {
            return "complete";
        }
    }

    static class CraftHangingLightsState
    implements State {
        final Balloon balloon = new Balloon(new LazyItemStack(FLItems.HANGING_LIGHTS, Item::getDefaultInstance), (Component)Component.translatable((String)"tutorial.fairylights.craft_hanging_lights.title"), (Component)Component.translatable((String)"tutorial.fairylights.craft_hanging_lights.description"));

        CraftHangingLightsState() {
        }

        @Override
        public String name() {
            return "hanging_lights";
        }

        @Override
        public void start() {
            Minecraft.getInstance().getToasts().addToast((Toast)this.balloon);
        }

        @Override
        public void tick(LocalPlayer player, ClippyController controller) {
            if (FLItems.HANGING_LIGHTS.value() != null && (player.getInventory().getSelected().getItem() == FLItems.HANGING_LIGHTS.value() || player.getInventory().contains(new ItemStack((ItemLike)FLItems.HANGING_LIGHTS.value())) || player.getStats().getValue(Stats.ITEM_CRAFTED.get((Object)((Item)FLItems.HANGING_LIGHTS.value()))) > 0)) {
                controller.setState(new CompleteState());
            }
        }

        @Override
        public void stop() {
            this.balloon.hide();
        }
    }
}

