/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.paulf.fairylights.data.GenericRecipeBuilder;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="fairylights", bus=EventBusSubscriber.Bus.MOD)
public final class DataGatherer {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableGenerator(gen));
    }

    static RecipeOutput addNbt(final RecipeOutput consumer, CompoundTag nbt) {
        return new RecipeOutput(){

            public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
                consumer.accept(id, recipe, advancement, conditions);
            }

            public Advancement.Builder advancement() {
                return consumer.advancement();
            }
        };
    }

    static class RecipeGenerator
    extends RecipeProvider {
        RecipeGenerator(PackOutput generator) {
            super(generator, CompletableFuture.completedFuture(RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)));
        }

        protected void buildRecipes(RecipeOutput consumer) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("text", (Tag)StyledString.serialize(new StyledString()));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.LETTER_BUNTING.get())).pattern("I-I").pattern("PBF").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('-'), (ItemLike)Items.STRING).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('B'), (ItemLike)Items.INK_SAC).define(Character.valueOf('F'), Tags.Items.FEATHERS).unlockedBy("has_iron", RecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_string", RecipeGenerator.has((ItemLike)Items.STRING)).save(DataGatherer.addNbt(consumer, nbt));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.GARLAND.get()), (int)2).pattern("I-I").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('-'), (ItemLike)Items.VINE).unlockedBy("has_iron", RecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_vine", RecipeGenerator.has((ItemLike)Items.VINE)).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.OIL_LANTERN.get()), (int)4).pattern(" I ").pattern("STS").pattern("IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), (ItemLike)Items.TORCH).define(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).unlockedBy("has_iron", RecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_torch", RecipeGenerator.has((ItemLike)Items.TORCH)).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.CANDLE_LANTERN.get()), (int)4).pattern(" I ").pattern("GTG").pattern("IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_iron", RecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_torch", RecipeGenerator.has((ItemLike)Items.TORCH)).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.INCANDESCENT_LIGHT.get()), (int)4).pattern(" I ").pattern("ITI").pattern(" G ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_iron", RecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_torch", RecipeGenerator.has((ItemLike)Items.TORCH)).save(consumer);
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS.get()).unlockedBy("has_lights", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(FLCraftingRecipes.LIGHTS).build()})).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"hanging_lights"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS_AUGMENTATION.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"hanging_lights_augmentation"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.TINSEL_GARLAND.get()).unlockedBy("has_iron", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(Tags.Items.INGOTS_IRON).build()})).unlockedBy("has_string", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STRING})).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"tinsel_garland"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING.get()).unlockedBy("has_pennants", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(FLCraftingRecipes.PENNANTS).build()})).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"pennant_bunting"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING_AUGMENTATION.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"pennant_bunting_augmentation"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.EDIT_COLOR.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"edit_color"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.COPY_COLOR.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"copy_color"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.TRIANGLE_PENNANT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"triangle_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SPEARHEAD_PENNANT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"spearhead_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SWALLOWTAIL_PENNANT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"swallowtail_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SQUARE_PENNANT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"square_pennant"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.FAIRY_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"fairy_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.PAPER_LANTERN.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"paper_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.ORB_LANTERN.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"orb_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.FLOWER_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"flower_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.CANDLE_LANTERN_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"candle_lantern_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.OIL_LANTERN_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"oil_lantern_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.JACK_O_LANTERN.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"jack_o_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SKULL_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"skull_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.GHOST_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"ghost_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SPIDER_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"spider_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.WITCH_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"witch_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SNOWFLAKE_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"snowflake_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.HEART_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"heart_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.MOON_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"moon_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.STAR_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"star_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.ICICLE_LIGHTS.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"icicle_lights"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.METEOR_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"meteor_light"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.LIGHT_TWINKLE.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"light_twinkle"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.COLOR_CHANGING_LIGHT.get()).build(consumer, ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"color_changing_light"));
        }

        GenericRecipeBuilder lightRecipe(RecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).unlockedBy("has_iron", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(Tags.Items.INGOTS_IRON).build()})).unlockedBy("has_dye", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(Tags.Items.DYES).build()}));
        }

        GenericRecipeBuilder pennantRecipe(RecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).unlockedBy("has_paper", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PAPER})).unlockedBy("has_string", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STRING}));
        }
    }

    static class LootTableGenerator
    extends LootTableProvider {
        LootTableGenerator(DataGenerator generator) {
            super(generator.getPackOutput(), Set.of(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(provider -> new BlockLootTableGenerator((HolderLookup.Provider)provider), LootContextParamSets.BLOCK)), CompletableFuture.completedFuture(RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)));
        }

        public List<LootTableProvider.SubProviderEntry> getTables() {
            return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(provider -> new BlockLootTableGenerator((HolderLookup.Provider)provider), LootContextParamSets.BLOCK));
        }
    }

    static class BlockLootTableGenerator
    extends BlockLootSubProvider {
        protected BlockLootTableGenerator(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return FLBlocks.REG.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
        }

        protected void generate() {
            this.add((Block)FLBlocks.FASTENER.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.FAIRY_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.PAPER_LANTERN.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.ORB_LANTERN.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.FLOWER_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.CANDLE_LANTERN_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.OIL_LANTERN_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.JACK_O_LANTERN.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.SKULL_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.GHOST_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.SPIDER_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.WITCH_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.SNOWFLAKE_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.HEART_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.MOON_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.STAR_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.ICICLE_LIGHTS.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.METEOR_LIGHT.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.OIL_LANTERN.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.CANDLE_LANTERN.get(), BlockLootTableGenerator.noDrop());
            this.add((Block)FLBlocks.INCANDESCENT_LIGHT.get(), BlockLootTableGenerator.noDrop());
        }
    }
}

