/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.data;

import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class GenericRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();

    public GenericRecipeBuilder(RecipeSerializer<?> serializer) {
        this.serializer = Objects.requireNonNull(serializer, "serializer");
    }

    public GenericRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.advancementBuilder.addCriterion(name, criterion);
        return this;
    }

    public void build(RecipeOutput consumer, ResourceLocation id) {
        AdvancementHolder advancement = null;
        try {
            ResourceLocation advancementId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("recipes/fairylights/" + id.getPath()));
            Advancement.Builder builder = this.advancementBuilder.parent(ResourceLocation.parse((String)"minecraft:recipes/root")).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            advancement = builder.build(advancementId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        consumer.accept(id, (Recipe)new Result(this.serializer, id), advancement);
    }

    public static GenericRecipeBuilder customRecipe(RecipeSerializer<?> serializer) {
        return new GenericRecipeBuilder(serializer);
    }

    static class Result
    implements CraftingRecipe {
        final RecipeSerializer<?> serializer;
        final ResourceLocation id;

        public Result(RecipeSerializer<?> serializer, ResourceLocation id) {
            this.serializer = serializer;
            this.id = id;
        }

        public RecipeSerializer<?> getSerializer() {
            return this.serializer;
        }

        public CraftingBookCategory category() {
            return CraftingBookCategory.MISC;
        }

        public RecipeType<?> getType() {
            return RecipeType.CRAFTING;
        }

        public boolean matches(CraftingInput input, Level level) {
            return false;
        }

        public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
            return ItemStack.EMPTY;
        }

        public boolean canCraftInDimensions(int width, int height) {
            return true;
        }

        public ItemStack getResultItem(HolderLookup.Provider provider) {
            return ItemStack.EMPTY;
        }
    }
}

