/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server;

import java.util.Optional;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleLibrary;
import me.paulf.fairylights.server.jingle.JingleManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="fairylights")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        CapabilityHandler.getFastenerCapability((Entity)player).ifPresent(fastener -> {
            Optional<Connection> connection = fastener.getFirstConnection();
            if (connection.isPresent()) {
                if (ServerEventHandler.isHoldingConnection(player, connection.get())) {
                    return;
                }
                fastener.removeConnection(connection.get());
            }
        });
    }

    private static boolean isHoldingConnection(Player player, Connection connection) {
        return ServerEventHandler.isHoldingConnection(player.getItemInHand(InteractionHand.MAIN_HAND), connection) || ServerEventHandler.isHoldingConnection(player.getItemInHand(InteractionHand.OFF_HAND), connection);
    }

    private static boolean isHoldingConnection(ItemStack stack, Connection connection) {
        return stack.getItem() instanceof ConnectionItem && ((ConnectionItem)stack.getItem()).getConnectionType() == connection.getType();
    }

    public static void tryJingle(Level world, Connection connection) {
        if (!(connection instanceof HangingLightsConnection)) {
            return;
        }
        HangingLightsConnection hangingLightsConnection = (HangingLightsConnection)connection;
        JingleLibrary library = JingleManager.INSTANCE.get("christmas");
        Jingle jingle = library.getRandom(world.random, 100);
        if (jingle != null) {
            hangingLightsConnection.play(jingle, 0);
        }
    }
}

