/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server;

import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.BlockView;
import me.paulf.fairylights.server.fastener.CreateBlockViewEvent;
import me.paulf.fairylights.server.fastener.RegularBlockView;
import me.paulf.fairylights.server.jingle.JingleManager;
import me.paulf.fairylights.server.net.Message;
import me.paulf.fairylights.server.net.NetBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ServerProxy {
    public void init(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(e -> e.addListener((PreparableReloadListener)JingleManager.INSTANCE));
        modBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityHandler.register();
    }

    public static void sendToPlayersWatchingChunk(Object message, Level world, BlockPos pos) {
    }

    public static void sendToPlayersWatchingEntity(Object message, Entity entity) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        NetBuilder network = (NetBuilder)FairyLights.NETWORK;
        if (network == null) {
            return;
        }
        for (ServerPlayer player : serverLevel.getPlayers(p -> p.distanceToSqr(entity) < 4096.0 || p.equals((Object)entity))) {
            try {
                if (message instanceof Message) {
                    network.sendToClient((Message)message, player);
                    continue;
                }
                if (!(message instanceof CustomPacketPayload)) continue;
                CustomPacketPayload payload = (CustomPacketPayload)message;
                player.connection.send((Packet)new ClientboundCustomPayloadPacket(payload));
            }
            catch (Exception exception) {}
        }
    }

    public static BlockView buildBlockView() {
        CreateBlockViewEvent evt = new CreateBlockViewEvent(new RegularBlockView());
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt.getView();
    }

    public void initIntegration() {
    }
}

