/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerEventHandler;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.fastener.accessor.BlockFastenerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class FastenerBlock
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final MapCodec<FastenerBlock> CODEC = FastenerBlock.simpleCodec(FastenerBlock::new);
    private static final VoxelShape NORTH_AABB = Block.box((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
    private static final VoxelShape WEST_AABB = Block.box((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWN_AABB = Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UP_AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public FastenerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirrorIn.mirror((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        System.err.println("FL_DEBUG_CRITICAL: FastenerBlock.newBlockEntity at " + String.valueOf(pos));
        return new FastenerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return FastenerBlock.createTickerHelper(type, (BlockEntityType)FLBlockEntities.FASTENER.get(), FastenerBlockEntity::tickClient);
        }
        return FastenerBlock.createTickerHelper(type, (BlockEntityType)FLBlockEntities.FASTENER.get(), FastenerBlockEntity::tick);
    }

    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, BlockEntityType<E> expect, BlockEntityTicker<? super E> ticker) {
        return expect == actual ? ticker : null;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof FastenerBlockEntity) {
                CapabilityHandler.getFastenerCapability(entity).ifPresent(f -> f.dropItems(world, pos));
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos attachedPos = pos.relative(facing.getOpposite());
        BlockState attachedState = world.getBlockState(attachedPos);
        return attachedState.is(BlockTags.LEAVES) || attachedState.isFaceSturdy((BlockGetter)world, attachedPos, facing) || facing == Direction.UP && attachedState.is(BlockTags.WALLS);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState result = this.defaultBlockState();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction dir : context.getNearestLookingDirections()) {
            if (!(result = (BlockState)result.setValue((Property)FACING, (Comparable)dir.getOpposite())).canSurvive((LevelReader)world, pos)) continue;
            return (BlockState)result.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos.relative(dir))));
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.canSurvive((LevelReader)world, pos)) {
            boolean receivingPower = world.hasNeighborSignal(pos);
            boolean isPowered = (Boolean)state.getValue((Property)TRIGGERED);
            if (receivingPower && !isPowered) {
                world.scheduleTick(pos, (Block)this, 2);
                world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
            } else if (!receivingPower && isPowered) {
                world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            }
        } else {
            BlockEntity entity = world.getBlockEntity(pos);
            FastenerBlock.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
            world.removeBlock(pos, false);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity == null) {
            return super.getAnalogOutputSignal(state, world, pos);
        }
        return CapabilityHandler.getFastenerCapability(entity).map(f -> f.getAllConnections().stream()).orElse(Stream.empty()).filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).mapToInt(c -> (int)Math.ceil(c.getJingleProgress() * 15.0f)).max().orElse(0);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.jingle((Level)world, pos);
    }

    private void jingle(Level world, BlockPos pos) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof FastenerBlockEntity)) {
            return;
        }
        CapabilityHandler.getFastenerCapability(entity).ifPresent(fastener -> fastener.getAllConnections().stream().filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).filter(conn -> conn.canCurrentlyPlayAJingle() && conn.isDestination(new BlockFastenerAccessor(fastener.getPos())) && (Boolean)world.getBlockState(fastener.getPos()).getValue((Property)TRIGGERED) != false).findFirst().ifPresent(conn -> ServerEventHandler.tryJingle(world, conn)));
    }

    public Vec3 getOffset(Direction facing, float offset) {
        return FastenerBlock.getFastenerOffset(facing, offset);
    }

    public static Vec3 getFastenerOffset(Direction facing, float offset) {
        double x = offset;
        double y = offset;
        double z = offset;
        switch (facing) {
            case DOWN: {
                y += 0.75;
            }
            case UP: {
                x += 0.375;
                z += 0.375;
                break;
            }
            case WEST: {
                x += 0.75;
            }
            case EAST: {
                z += 0.375;
                y += 0.375;
                break;
            }
            case NORTH: {
                z += 0.75;
            }
            case SOUTH: {
                x += 0.375;
                y += 0.375;
            }
        }
        return new Vec3(x, y, z);
    }
}

