/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LightBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private final MapCodec<LightBlock> codec;
    private static final VoxelShape MIN_ANCHOR_SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private final VoxelShape floorShape;
    private final VoxelShape eastWallShape;
    private final VoxelShape westWallShape;
    private final VoxelShape northWallShape;
    private final VoxelShape southWallShape;
    private final VoxelShape ceilingShape;
    private final LightVariant<?> variant;

    public LightBlock(BlockBehaviour.Properties properties, LightVariant<?> variant) {
        super(properties);
        this.variant = variant;
        this.codec = LightBlock.simpleCodec(p -> new LightBlock((BlockBehaviour.Properties)p, variant));
        AABB bb = this.variant.getBounds();
        double w = Math.max(bb.getXsize(), bb.getZsize());
        double w0 = 0.5 - w * 0.5;
        double w1 = 0.5 + w * 0.5;
        if (variant.isOrientable()) {
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, -bb.minY, w1);
            this.eastWallShape = LightBlock.clampBox(0.0, w0, w0, -bb.minY, w1, w1);
            this.westWallShape = LightBlock.clampBox(1.0 + bb.minY, w0, w0, 1.0, w1, w1);
            this.southWallShape = LightBlock.clampBox(w0, w0, 0.0, w1, w1, -bb.minY);
            this.northWallShape = LightBlock.clampBox(w0, w0, 1.0 + bb.minY, w1, w1, 1.0);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.minY, w0, w1, 1.0, w1);
        } else {
            double t = 0.125;
            double u = 0.6875;
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, bb.getYsize() - this.variant.getFloorOffset(), w1);
            this.eastWallShape = LightBlock.clampBox(w0 - 0.125, 0.6875 + bb.minY, w0, w1 - 0.125, 0.6875 + bb.maxY, w1);
            this.westWallShape = LightBlock.clampBox(w0 + 0.125, 0.6875 + bb.minY, w0, w1 + 0.125, 0.6875 + bb.maxY, w1);
            this.southWallShape = LightBlock.clampBox(w0, 0.6875 + bb.minY, w0 - 0.125, w1, 0.6875 + bb.maxY, w1 - 0.125);
            this.northWallShape = LightBlock.clampBox(w0, 0.6875 + bb.minY, w0 + 0.125, w1, 0.6875 + bb.maxY, w1 + 0.125);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.minY - 0.25, w0, w1, 1.0, w1);
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return this.codec;
    }

    private static VoxelShape clampBox(double x0, double y0, double z0, double x1, double y1, double z1) {
        return Shapes.box((double)Mth.clamp((double)x0, (double)0.0, (double)1.0), (double)Mth.clamp((double)y0, (double)0.0, (double)1.0), (double)Mth.clamp((double)z0, (double)0.0, (double)1.0), (double)Mth.clamp((double)x1, (double)0.0, (double)1.0), (double)Mth.clamp((double)y1, (double)0.0, (double)1.0), (double)Mth.clamp((double)z1, (double)0.0, (double)1.0));
    }

    public LightVariant<?> getVariant() {
        return this.variant;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LightBlockEntity(pos, state);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        AttachFace value = (AttachFace)state.getValue((Property)FACE);
        if (value == AttachFace.WALL) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPos anchorPos = pos.relative(facing.getOpposite());
            BlockState anchorState = world.getBlockState(anchorPos);
            if (anchorState.is(BlockTags.LEAVES)) {
                return true;
            }
            VoxelShape shape = anchorState.getBlockSupportShape((BlockGetter)world, anchorPos);
            return Block.isFaceFull((VoxelShape)shape, (Direction)facing);
        }
        Direction facing = value == AttachFace.FLOOR ? Direction.DOWN : Direction.UP;
        BlockPos anchorPos = pos.relative(facing);
        BlockState anchorState = world.getBlockState(anchorPos);
        if (anchorState.is(BlockTags.LEAVES)) {
            return true;
        }
        VoxelShape shape = anchorState.getBlockSupportShape((BlockGetter)world, anchorPos);
        return !Shapes.joinIsNotEmpty((VoxelShape)shape.getFaceShape(facing.getOpposite()), (VoxelShape)MIN_ANCHOR_SHAPE, (BooleanOp)BooleanOp.ONLY_SECOND);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction dir : context.getNearestLookingDirections()) {
            BlockState state = dir.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)(dir == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)dir.getOpposite());
            if (!state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof LightBlockEntity) {
            ItemStack lightItem = stack.copy();
            lightItem.setCount(1);
            ((LightBlockEntity)entity).setItemStack(lightItem);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity entity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (entity instanceof LightBlockEntity) {
            return Collections.singletonList(((LightBlockEntity)entity).getLight().getItem().copy());
        }
        return Collections.emptyList();
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).interact(world, pos, state, player, hand, hit);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rng) {
        super.animateTick(state, world, pos, rng);
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).animateTick();
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.getValue((Property)FACE)) {
            default: {
                return this.floorShape;
            }
            case WALL: {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        return this.eastWallShape;
                    }
                    case WEST: {
                        return this.westWallShape;
                    }
                    case SOUTH: {
                        return this.southWallShape;
                    }
                    case NORTH: 
                }
                return this.northWallShape;
            }
            case CEILING: 
        }
        return this.ceilingShape;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof LightBlockEntity) {
            return ((LightBlockEntity)entity).getLight().getItem().copy();
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        DyeableItem.setColor(stack, DyeColor.YELLOW);
        return stack;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACE, FACING, LIT});
    }
}

