/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.fastener.AbstractFastener;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class FastenerBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockFastener fastener;

    public FastenerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.FASTENER.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public Vec3 getOffset() {
        return ((FastenerBlock)((Object)FLBlocks.FASTENER.get())).getOffset(this.getFacing(), 0.125f);
    }

    public Direction getFacing() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock() != FLBlocks.FASTENER.get()) {
            return Direction.UP;
        }
        return (Direction)state.getValue((Property)FastenerBlock.FACING);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.getFastener().ifPresent(f -> {
            CompoundTag fastenerTag = f.serializeNBT();
            tag.put("fastener", (Tag)fastenerTag);
        });
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        if (tag.contains("fastener", 10)) {
            LogUtils.getLogger().info("FL_DEBUG: FastenerBlockEntity.handleUpdateTag (CLIENT) - received update tag");
            this.getFastener().ifPresent(f -> {
                if (f instanceof AbstractFastener) {
                    AbstractFastener af = (AbstractFastener)f;
                    CompoundTag fastenerTag = tag.getCompound("fastener");
                    LogUtils.getLogger().info("FL_DEBUG: FastenerBlockEntity.handleUpdateTag - calling deserializeNBT");
                    af.deserializeNBT(fastenerTag, provider);
                }
            });
        }
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        this.getFastener().ifPresent(f -> f.setWorld(world));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FastenerBlockEntity be) {
        be.getFastener().ifPresent(fastener -> {
            if (!level.isClientSide() && fastener.hasNoConnections()) {
                level.removeBlock(pos, false);
            } else if (!level.isClientSide() && fastener.update()) {
                be.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
        });
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, FastenerBlockEntity be) {
        be.getFastener().ifPresent(f -> f.update());
    }

    public void onLoad() {
        super.onLoad();
        LOGGER.error("FL_DEBUG_CRITICAL: FastenerBlockEntity.onLoad at " + String.valueOf(this.worldPosition));
    }

    public void setRemoved() {
        this.getFastener().ifPresent(Fastener::remove);
        super.setRemoved();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.getFastener().ifPresent(f -> {
            CompoundTag fastenerTag = f.serializeNBT();
            tag.put("fastener", (Tag)fastenerTag);
        });
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("fastener", 10)) {
            this.getFastener().ifPresent(f -> {
                if (f instanceof AbstractFastener) {
                    AbstractFastener af = (AbstractFastener)f;
                    af.deserializeNBT(tag.getCompound("fastener"), provider);
                }
            });
        }
    }

    public Optional<Fastener<?>> getFastener() {
        if (this.fastener == null) {
            this.fastener = new BlockFastener(this, ServerProxy.buildBlockView());
            if (this.level != null) {
                this.fastener.setWorld(this.level);
            }
        }
        return Optional.of(this.fastener);
    }
}

