/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block.entity;

import com.mojang.logging.LogUtils;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class LightBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Light<?> light;
    private boolean on = true;

    public LightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.LIGHT.get(), pos, state);
        LightVariant<StandardLightBehavior> variant;
        Block block = state.getBlock();
        if (block instanceof LightBlock) {
            LightBlock lightBlock = (LightBlock)block;
            variant = lightBlock.getVariant();
        } else {
            variant = SimpleLightVariant.FAIRY_LIGHT;
        }
        this.light = new Light<StandardLightBehavior>(0, Vec3.ZERO, 0.0f, 0.0f, ItemStack.EMPTY, variant, 0.0f);
    }

    public Light<?> getLight() {
        return this.light;
    }

    public void setItemStack(ItemStack stack) {
        LightVariant<StandardLightBehavior> variant;
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof LightBlock) {
            LightBlock lightBlock = (LightBlock)block;
            variant = lightBlock.getVariant();
        } else {
            variant = SimpleLightVariant.FAIRY_LIGHT;
        }
        this.light = new Light<StandardLightBehavior>(0, Vec3.ZERO, 0.0f, 0.0f, stack, variant, 0.0f);
        this.setChanged();
    }

    private void setOn(boolean on) {
        this.on = on;
        this.light.power(on, true);
        this.setChanged();
    }

    public void interact(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        float pitch;
        SoundEvent lightSnd;
        this.setOn(!this.on);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LightBlock.LIT, (Comparable)Boolean.valueOf(this.on)));
        if (this.on) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.level.playSound(null, pos, lightSnd, SoundSource.BLOCKS, 1.0f, pitch);
    }

    public void animateTick() {
        BlockState state = this.getBlockState();
        AttachFace face = (AttachFace)state.getValue((Property)LightBlock.FACE);
        float rotation = ((Direction)state.getValue((Property)LightBlock.FACING)).toYRot();
        MatrixStack matrix = new MatrixStack();
        matrix.translate(0.5f, 0.5f, 0.5f);
        matrix.rotate((float)Math.toRadians(180.0f - rotation), 0.0f, 1.0f, 0.0f);
        if (this.light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.rotate(1.5707964f, 1.0f, 0.0f, 0.0f);
            } else if (face == AttachFace.FLOOR) {
                matrix.rotate((float)(-Math.PI), 1.0f, 0.0f, 0.0f);
            }
            matrix.translate(0.0f, 0.5f, 0.0f);
        } else if (face == AttachFace.CEILING) {
            matrix.translate(0.0f, 0.25f, 0.0f);
        } else if (face == AttachFace.WALL) {
            matrix.translate(0.0f, 0.1875f, 0.125f);
        } else {
            matrix.translate(0.0f, -((float)this.light.getVariant().getBounds().minY) - 0.5f, 0.0f);
        }
        this.light.getBehavior().animateTick(this.level, Vec3.atLowerCornerOf((Vec3i)this.worldPosition).add(matrix.transform(Vec3.ZERO)), this.light);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.loadAdditional(tag, provider);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        ItemStack item = this.light.getItem();
        if (!item.isEmpty()) {
            compound.put("item", item.save(provider));
        }
        compound.putBoolean("on", this.on);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        ItemStack item;
        super.loadAdditional(compound, provider);
        if (compound.contains("item") && (item = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compound.getCompound("item")).orElse(ItemStack.EMPTY)) != null && !item.isEmpty()) {
            this.setItemStack(item);
        }
        this.setOn(compound.getBoolean("on"));
    }
}

