/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.capability;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.PlayerFastener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class CapabilityHandler {
    public static final ResourceLocation FASTENER_ID = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"fastener");
    private static final WeakHashMap<Player, PlayerFastener> playerFasteners = new WeakHashMap();

    private CapabilityHandler() {
    }

    public static void register() {
    }

    public static Optional<Fastener<?>> getFastenerCapability(BlockEntity entity) {
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof FastenerBlockEntity) {
            FastenerBlockEntity fastenerBe = (FastenerBlockEntity)entity;
            return fastenerBe.getFastener();
        }
        try {
            Method getCapability = entity.getClass().getMethod("getCapability", ResourceLocation.class);
            Optional<Fastener<?>> cap = (Optional<Fastener<?>>)getCapability.invoke((Object)entity, FASTENER_ID);
            return cap != null ? cap : Optional.empty();
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<Fastener<?>> getFastenerCapability(Entity entity) {
        PlayerFastener fastener;
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof FenceFastenerEntity) {
            FenceFastenerEntity fenceFastener = (FenceFastenerEntity)entity;
            return fenceFastener.getFastener();
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerFastener f = playerFasteners.computeIfAbsent(player, PlayerFastener::new);
            f.setWorld(player.level());
            return Optional.of(f);
        }
        try {
            Method getData = entity.getClass().getMethod("getData", ResourceLocation.class);
            Object data = getData.invoke((Object)entity, FASTENER_ID);
            if (data instanceof Fastener) {
                return Optional.of((Fastener)data);
            }
            if (data == null && entity instanceof Player) {
                fastener = new PlayerFastener((Player)entity);
                try {
                    Method setData = entity.getClass().getMethod("setData", ResourceLocation.class, Object.class);
                    setData.invoke((Object)entity, FASTENER_ID, fastener);
                    return Optional.of(fastener);
                }
                catch (Exception setData) {}
            }
        }
        catch (Throwable getData) {
            // empty catch block
        }
        try {
            Method getCapability = entity.getClass().getMethod("getCapability", ResourceLocation.class);
            Optional<Fastener<?>> cap = (Optional<Fastener<?>>)getCapability.invoke((Object)entity, FASTENER_ID);
            if (cap != null && cap.isPresent()) {
                return cap;
            }
            if ((cap == null || cap.isEmpty()) && entity instanceof Player) {
                fastener = new PlayerFastener((Player)entity);
                try {
                    Method addCapability = entity.getClass().getMethod("addCapability", ResourceLocation.class, Object.class);
                    addCapability.invoke((Object)entity, FASTENER_ID, fastener);
                    return Optional.of(fastener);
                }
                catch (Exception e2) {
                    try {
                        Method getOrCreate = entity.getClass().getMethod("getOrCreateCapability", ResourceLocation.class, Supplier.class);
                        cap = (Optional)getOrCreate.invoke((Object)entity, FASTENER_ID, () -> fastener);
                        return cap != null ? cap : Optional.of(fastener);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }
}

