/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.collision;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import net.minecraft.world.phys.Vec3;

public final class CollidableList
implements Collidable {
    private final ImmutableList<Collidable> collision;

    private CollidableList(Builder builder) {
        this.collision = builder.collision.build();
    }

    @Override
    @Nullable
    public Intersection intersect(Vec3 origin, Vec3 end) {
        Intersection result = null;
        double distance = Double.MAX_VALUE;
        for (Collidable collidable : this.collision) {
            double d;
            Intersection r = collidable.intersect(origin, end);
            if (r == null || !((d = r.getResult().distanceTo(origin)) < distance)) continue;
            result = r;
            distance = d;
        }
        return result;
    }

    public static class Builder {
        final ImmutableList.Builder<Collidable> collision = new ImmutableList.Builder();

        public Builder add(Collidable collidable) {
            this.collision.add((Object)collidable);
            return this;
        }

        public CollidableList build() {
            return new CollidableList(this);
        }
    }
}

