/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.collision;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class FeatureCollisionTree
implements Collidable {
    private final FeatureType type;
    public final AABB[] tree;
    private final Feature[] nodeToFeature;

    private FeatureCollisionTree(FeatureType type, AABB[] tree, Feature[] nodeToFeature) {
        this.type = type;
        this.tree = tree;
        this.nodeToFeature = nodeToFeature;
    }

    @Override
    @Nullable
    public Intersection intersect(Vec3 origin, Vec3 end) {
        return this.intersect(origin, end, 0);
    }

    @Nullable
    private Intersection intersect(Vec3 origin, Vec3 end, int node) {
        Vec3 result = this.tree[node].contains(origin) ? origin : (Vec3)this.tree[node].clip(origin, end).orElse(null);
        if (result == null) {
            return null;
        }
        int nL = node * 2 + 1;
        if (nL >= this.tree.length || this.tree[nL] == null) {
            return new Intersection(result, this.tree[node], this.type, this.nodeToFeature[node]);
        }
        Intersection intersection = this.intersect(origin, end, nL);
        if (intersection != null) {
            return intersection;
        }
        return this.intersect(origin, end, node * 2 + 2);
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, AABB> mapper) {
        return FeatureCollisionTree.build((FeatureType)type, features, mapper, (int)0, (int)(features.length - 1));
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, AABB> mapper, int start, int end) {
        return FeatureCollisionTree.build(type, i -> features[i], (int i) -> (AABB)mapper.apply(features[i]), start, end);
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, IntFunction<T> features, IntFunction<AABB> mapper, int start, int end) {
        AABB[] tree = new AABB[end == 0 ? 1 : (1 << FLMth.log2(end - start) + 2) - 1];
        Feature[] treeFeatures = new Feature[tree.length];
        tree[0] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, start, end, 0);
        return new FeatureCollisionTree(type, tree, treeFeatures);
    }

    private static <T extends Feature> AABB build(IntFunction<T> features, IntFunction<AABB> mapper, AABB[] tree, Feature[] treeFeatures, int min, int max, int node) {
        if (min > max) {
            throw new IllegalStateException(String.format("min > max, tree: %s, min: %d, max: %d, node: %d", Arrays.toString(tree), min, max, node));
        }
        if (min == max) {
            treeFeatures[node] = (Feature)features.apply(min);
            return mapper.apply(min);
        }
        int mid = min + (max - min) / 2;
        int nL = node * 2 + 1;
        int nR = node * 2 + 2;
        tree[nL] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, min, mid, nL);
        tree[nR] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, mid + 1, max, nR);
        return tree[nL].minmax(tree[nR]);
    }
}

