/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.FenceFastener;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.net.serverbound.InteractionConnectionMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.Curve3d;
import me.paulf.fairylights.util.NBTSerializable;
import me.paulf.fairylights.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class Connection
implements NBTSerializable {
    public static final int MAX_LENGTH = 32;
    public static final double PULL_RANGE = 5.0;
    public static final FeatureType CORD_FEATURE = FeatureType.register("cord");
    private static final CubicBezier SLACK_CURVE = new CubicBezier(0.495f, 0.505f, 0.495f, 0.505f);
    private static final float MAX_SLACK = 3.0f;
    private final ConnectionType<?> type;
    protected final Fastener<?> fastener;
    private final UUID uuid;
    private FastenerAccessor destination;
    @Nullable
    private FastenerAccessor prevDestination;
    protected Level world;
    @Nullable
    private Curve catenary;
    @Nullable
    protected Curve prevCatenary;
    protected float slack = 1.0f;
    private Collidable collision = Collidable.empty();
    private boolean updateCatenary;
    private int prevStretchStage;
    private boolean removed;
    private boolean drop;

    public Connection(ConnectionType<?> type, Level world, Fastener<?> fastener, UUID uuid) {
        this.type = type;
        this.world = world;
        this.fastener = fastener;
        this.uuid = uuid;
        this.computeCatenary();
    }

    public ConnectionType<?> getType() {
        return this.type;
    }

    @Nullable
    public final Curve getCatenary() {
        return this.catenary;
    }

    @Nullable
    public final Curve getPrevCatenary() {
        return this.prevCatenary == null ? this.catenary : this.prevCatenary;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public final Level getWorld() {
        return this.world;
    }

    public final Collidable getCollision() {
        return this.collision;
    }

    public final Fastener<?> getFastener() {
        return this.fastener;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setDestination(Fastener<?> destination) {
        this.prevDestination = this.destination;
        this.destination = destination.createAccessor();
        this.computeCatenary();
    }

    public final FastenerAccessor getDestination() {
        return this.destination;
    }

    public boolean isDestination(FastenerAccessor location) {
        return this.destination.equals(location);
    }

    public void setDrop() {
        this.drop = true;
    }

    public void noDrop() {
        this.drop = false;
    }

    public boolean shouldDrop() {
        return this.drop;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getType().getItem());
        CompoundTag tagCompound = this.serializeLogic();
        if (!tagCompound.isEmpty()) {
            stack.set(FLDataComponents.CONNECTION_LOGIC, (Object)tagCompound);
        }
        return stack;
    }

    public float getRadius() {
        return 0.0625f;
    }

    public final boolean isDynamic() {
        return this.fastener.isMoving() || this.destination.get(this.world, false).filter(Fastener::isMoving).isPresent();
    }

    public final boolean isModifiable(Player player) {
        return this.world.mayInteract(player, this.fastener.getPos());
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            this.onRemove();
        }
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void computeCatenary() {
        this.updateCatenary = true;
    }

    public void processClientAction(Player player, PlayerAction action, Intersection intersection) {
        System.out.println("FL_DEBUG: Sending interaction packet for " + String.valueOf(this.getUUID()) + " action=" + String.valueOf((Object)action));
        PacketDistributor.sendToServer((CustomPacketPayload)new InteractionConnectionMessage(this, action, intersection), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void disconnect(Player player, Vec3 hit) {
        this.destination.get(this.world).ifPresent(f -> this.disconnect((Fastener<?>)f, hit));
    }

    private void disconnect(Fastener<?> destinationFastener, Vec3 hit) {
        this.fastener.removeConnection(this);
        destinationFastener.removeConnection(this.uuid);
        if (this.shouldDrop()) {
            ItemStack stack = this.getItemStack();
            ItemEntity item = new ItemEntity(this.world, hit.x, hit.y, hit.z, stack);
            float scale = 0.05f;
            item.setDeltaMovement(this.world.random.nextGaussian() * (double)0.05f, this.world.random.nextGaussian() * (double)0.05f + (double)0.2f, this.world.random.nextGaussian() * (double)0.05f);
            this.world.addFreshEntity((Entity)item);
        }
        this.world.playSound(null, hit.x, hit.y, hit.z, (SoundEvent)FLSounds.CORD_DISCONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean reconnect(Fastener<?> destination) {
        return this.fastener.reconnect(this.world, this, destination);
    }

    public boolean interact(Player player, Vec3 hit, FeatureType featureType, int feature, ItemStack heldStack, InteractionHand hand) {
        Item item = heldStack.getItem();
        if (item instanceof ConnectionItem && !this.matches(heldStack)) {
            return this.replace(player, hit, heldStack);
        }
        if (heldStack.is(Items.STRING)) {
            return this.slacken(hit, heldStack, 0.2f);
        }
        if (heldStack.is(Items.STICK)) {
            return this.slacken(hit, heldStack, -0.2f);
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        if (this.getType().getItem().equals(stack.getItem())) {
            CompoundTag tag = null;
            try {
                tag = (CompoundTag)stack.getClass().getMethod("getTag", new Class[0]).invoke((Object)stack, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tag == null || Utils.impliesNbt((Tag)this.serializeLogic(), tag);
        }
        return false;
    }

    private boolean replace(Player player, Vec3 hit, ItemStack heldStack) {
        return this.destination.get(this.world).map(dest -> {
            this.fastener.removeConnection(this);
            dest.removeConnection(this.uuid);
            if (this.shouldDrop()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getItemStack());
            }
            CompoundTag data = null;
            try {
                data = (CompoundTag)heldStack.getClass().getMethod("getTag", new Class[0]).invoke((Object)heldStack, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionType<?> type = ((ConnectionItem)heldStack.getItem()).getConnectionType();
            Connection conn = this.fastener.connect(this.world, (Fastener<?>)dest, type, data == null ? new CompoundTag() : data, true);
            conn.slack = this.slack;
            conn.onConnect(player.level(), player, heldStack);
            heldStack.shrink(1);
            this.world.playSound(null, hit.x, hit.y, hit.z, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }).orElse(false);
    }

    private boolean slacken(Vec3 hit, ItemStack heldStack, float amount) {
        if (this.slack <= 0.0f && amount < 0.0f || this.slack >= 3.0f && amount > 0.0f) {
            return true;
        }
        this.slack = Mth.clamp((float)(this.slack + amount), (float)0.0f, (float)3.0f);
        if (this.slack < 0.01f) {
            this.slack = 0.0f;
        }
        this.computeCatenary();
        this.world.playSound(null, hit.x, hit.y, hit.z, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + (3.0f - this.slack) * 0.4f);
        return true;
    }

    public void onConnect(Level world, Player user, ItemStack heldStack) {
    }

    protected void onRemove() {
    }

    protected void onUpdate() {
    }

    protected void onCalculateCatenary(boolean relocated) {
    }

    public final boolean update(Vec3 from) {
        this.prevCatenary = this.catenary;
        boolean changed = this.destination.get(this.world, false).map(dest -> {
            Vec3 point = dest.getConnectionPoint();
            boolean c = this.updateCatenary(from, (Fastener<?>)dest, point);
            this.onUpdate();
            double dist = point.distanceTo(from);
            double pull = dist - 32.0 + 5.0;
            if (pull > 0.0) {
                int stage = (int)(pull + (double)0.1f);
                if (stage > this.prevStretchStage) {
                    this.world.playSound(null, point.x, point.y, point.z, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundSource.BLOCKS, 0.25f, 0.5f + (float)stage / 8.0f);
                }
                this.prevStretchStage = stage;
            }
            if (dist > 37.0) {
                this.world.playSound(null, point.x, point.y, point.z, (SoundEvent)FLSounds.CORD_SNAP.get(), SoundSource.BLOCKS, 0.75f, 0.8f + this.world.random.nextFloat() * 0.3f);
                this.remove();
            } else if (dest.isMoving()) {
                dest.resistSnap(from);
            }
            return c;
        }).orElse(false);
        if (this.destination.isGone(this.world)) {
            this.remove();
        }
        return changed;
    }

    private boolean updateCatenary(Vec3 from, Fastener<?> dest, Vec3 point) {
        if (this.updateCatenary || this.isDynamic()) {
            Vec3 vec = point.subtract(from);
            if (vec.length() > 1.0E-6) {
                Direction facing = this.fastener.getFacing();
                this.catenary = this.fastener instanceof FenceFastener && dest instanceof FenceFastener && vec.horizontalDistance() < 0.01 ? this.verticalHelix(vec) : Catenary.from(vec, facing.getAxis() == Direction.Axis.Y ? 0.0f : (float)Math.toRadians(90.0f + facing.toYRot()), SLACK_CURVE, this.slack);
                this.onCalculateCatenary(!this.destination.equals(this.prevDestination));
                CollidableList.Builder bob = new CollidableList.Builder();
                this.addCollision(bob, from);
                this.collision = bob.build();
            }
            this.updateCatenary = false;
            this.prevDestination = this.destination;
            return true;
        }
        return false;
    }

    private Curve verticalHelix(Vec3 vec) {
        float length = (float)vec.length();
        float height = (float)vec.y;
        float stepSize = 0.25f;
        float loopsPerBlock = 1.0f;
        float radius = 0.33f;
        int steps = (int)(2.0734513f * length / 0.25f);
        float rad = (float)Math.PI * -2 * (1.0f * length);
        float[] x = new float[steps];
        float[] y = new float[steps];
        float[] z = new float[steps];
        float helixLength = 0.0f;
        for (int i = 0; i < steps; ++i) {
            float t = (float)i / (float)(steps - 1);
            x[i] = 0.33f * Mth.cos((float)(t * rad));
            y[i] = t * height;
            z[i] = 0.33f * Mth.sin((float)(t * rad));
            if (i <= 0) continue;
            helixLength += Mth.sqrt((float)(Mth.square((float)(x[i] - x[i - 1])) + Mth.square((float)(y[i] - y[i - 1])) + Mth.square((float)(z[i] - z[i - 1]))));
        }
        return new Curve3d(steps, x, y, z, helixLength);
    }

    public void addCollision(CollidableList.Builder collision, Vec3 origin) {
        if (this.catenary == null) {
            return;
        }
        int count = this.catenary.getCount();
        if (count <= 2) {
            return;
        }
        float r = this.getRadius();
        Curve.SegmentIterator it = this.catenary.iterator();
        AABB[] bounds = new AABB[count - 1];
        int index = 0;
        while (it.next()) {
            float x0 = it.getX(0.0f);
            float y0 = it.getY(0.0f);
            float z0 = it.getZ(0.0f);
            float x1 = it.getX(1.0f);
            float y1 = it.getY(1.0f);
            float z1 = it.getZ(1.0f);
            bounds[index++] = new AABB(origin.x + (double)x0, origin.y + (double)y0, origin.z + (double)z0, origin.x + (double)x1, origin.y + (double)y1, origin.z + (double)z1).inflate((double)r);
        }
        collision.add(FeatureCollisionTree.build(CORD_FEATURE, i -> Segment.INSTANCE, i -> bounds[i], 1, bounds.length - 2));
    }

    public void deserialize(Fastener<?> destination, CompoundTag compound, boolean drop, HolderLookup.Provider provider) {
        this.destination = destination.createAccessor();
        this.drop = drop;
        this.deserializeLogic(compound, provider);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        compound.put("destination", (Tag)FastenerType.serialize(this.destination));
        compound.put("logic", (Tag)this.serializeLogic());
        compound.putFloat("slack", this.slack);
        if (!this.drop) {
            compound.putBoolean("drop", false);
        }
        return compound;
    }

    @Override
    public void deserialize(CompoundTag compound) {
        throw new UnsupportedOperationException("Use deserialize(CompoundTag, HolderLookup.Provider)");
    }

    public void deserialize(CompoundTag compound, HolderLookup.Provider provider) {
        this.destination = FastenerType.deserialize(compound.getCompound("destination"));
        this.deserializeLogic(compound.getCompound("logic"), provider);
        this.slack = compound.contains("slack", 99) ? compound.getFloat("slack") : 1.0f;
        this.drop = !compound.contains("drop", 99) || compound.getBoolean("drop");
        this.updateCatenary = true;
    }

    public CompoundTag serializeLogic() {
        return new CompoundTag();
    }

    public void deserializeLogic(CompoundTag compound, HolderLookup.Provider provider) {
    }

    static class Segment
    implements Feature {
        static final Segment INSTANCE = new Segment();

        Segment() {
        }

        @Override
        public int getId() {
            return 0;
        }
    }
}

