/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import java.util.function.Supplier;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ConnectionType<T extends Connection> {
    private final Factory<T> factory;
    private final Supplier<? extends Item> item;

    public ConnectionType(Builder<T> builder) {
        this.factory = builder.factory;
        this.item = builder.item;
    }

    public T create(Level world, Fastener<?> fastener, UUID uuid) {
        return this.factory.create(this, world, fastener, uuid);
    }

    public Item getItem() {
        return this.item.get();
    }

    public static final class Builder<T extends Connection> {
        final Factory<T> factory;
        Supplier<? extends Item> item = () -> Items.AIR;

        private Builder(Factory<T> factory) {
            this.factory = factory;
        }

        public Builder<T> item(Supplier<? extends Item> item) {
            this.item = item;
            return this;
        }

        public ConnectionType<T> build() {
            return new ConnectionType(this);
        }

        public static <T extends Connection> Builder<T> create(Factory<T> factory) {
            return new Builder<T>(factory);
        }
    }

    public static interface Factory<T extends Connection> {
        public T create(ConnectionType<T> var1, Level var2, Fastener<?> var3, UUID var4);
    }
}

