/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.item.DyeableItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;

public final class GarlandTinselConnection
extends Connection {
    private int color = DyeableItem.getColor(DyeColor.LIGHT_GRAY);

    public GarlandTinselConnection(ConnectionType<? extends GarlandTinselConnection> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public float getRadius() {
        return 0.125f;
    }

    @Override
    public CompoundTag serializeLogic() {
        return DyeableItem.setColor(super.serializeLogic(), this.color);
    }

    @Override
    public void deserializeLogic(CompoundTag compound, HolderLookup.Provider provider) {
        super.deserializeLogic(compound, provider);
        this.color = DyeableItem.getColor(compound);
        LogManager.getLogger().info("[FairyLights] GarlandTinselConnection.deserializeLogic: compound={}, color={}", (Object)compound, (Object)Integer.toHexString(this.color));
    }
}

