/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.UUID;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.HangingFeature;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public abstract class HangingFeatureConnection<F extends HangingFeature>
extends Connection {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final FeatureType FEATURE;
    protected F[] features = this.createFeatures(0);

    public HangingFeatureConnection(ConnectionType<? extends HangingFeatureConnection<F>> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public final F[] getFeatures() {
        return this.features;
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateFeatures(relocated);
    }

    protected void updateFeatures(boolean relocated) {
        Curve catenary = this.getCatenary();
        float spacing = this.getFeatureSpacing();
        float totalLength = catenary.getLength();
        if (totalLength > 64.0f) {
            this.onBeforeUpdateFeatures();
            this.features = this.createFeatures(0);
            this.onAfterUpdateFeatures();
            return;
        }
        F[] prev = this.features;
        ArrayList features = new ArrayList();
        this.onBeforeUpdateFeatures();
        catenary.visitPoints(spacing, true, (index, x, y, z, yaw, pitch) -> {
            HangingFeature feature;
            if (!relocated && prev != null && index < prev.length && this.canReuse(prev[index], index)) {
                feature = prev[index];
                feature.set(new Vec3((double)x, (double)y, (double)z), yaw, pitch);
            } else {
                LOGGER.error("FL_DEBUG_CRITICAL: HangingFeatureConnection creating feature at index " + index);
                feature = this.createFeature(index, new Vec3((double)x, (double)y, (double)z), yaw, pitch);
            }
            this.updateFeature(feature);
            features.add(feature);
        });
        this.features = features.toArray(this.createFeatures(features.size()));
        this.onAfterUpdateFeatures();
    }

    protected boolean canReuse(F feature, int index) {
        return true;
    }

    protected abstract F[] createFeatures(int var1);

    protected abstract F createFeature(int var1, Vec3 var2, float var3, float var4);

    protected abstract float getFeatureSpacing();

    protected void onBeforeUpdateFeatures() {
    }

    protected void updateFeature(F feature) {
    }

    protected void onAfterUpdateFeatures() {
    }

    @Override
    public void addCollision(CollidableList.Builder collision, Vec3 origin) {
        super.addCollision(collision, origin);
        if (this.features.length > 0) {
            MatrixStack matrix = new MatrixStack();
            collision.add(FeatureCollisionTree.build((FeatureType)FEATURE, this.features, f -> {
                Vec3[] verts;
                Vec3 pos = f.getPoint();
                double x = origin.x + pos.x;
                double y = origin.y + pos.y;
                double z = origin.z + pos.z;
                matrix.push();
                if (f.parallelsCord()) {
                    matrix.rotate(-f.getYaw(), 0.0f, 1.0f, 0.0f);
                    matrix.rotate(f.getPitch(), 0.0f, 0.0f, 1.0f);
                }
                matrix.translate(0.0f, -f.getDescent(), 0.0f);
                AABBBuilder bounds = new AABBBuilder();
                AABB bb = f.getBounds().inflate(0.01);
                for (Vec3 vert : verts = new Vec3[]{new Vec3(bb.minX, bb.minY, bb.minZ), new Vec3(bb.maxX, bb.minY, bb.minZ), new Vec3(bb.maxX, bb.minY, bb.minZ), new Vec3(bb.minX, bb.minY, bb.maxZ), new Vec3(bb.minX, bb.maxY, bb.minZ), new Vec3(bb.maxX, bb.maxY, bb.minZ), new Vec3(bb.maxX, bb.maxY, bb.maxZ), new Vec3(bb.minX, bb.maxY, bb.maxZ)}) {
                    bounds.include(matrix.transform(vert));
                }
                matrix.pop();
                return bounds.add(x, y, z).build();
            }));
        }
    }

    static {
        LOGGER.error("FL_DEBUG_CRITICAL: HangingFeatureConnection CLASS LOADED");
        FEATURE = FeatureType.register("feature");
    }
}

