/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.HangingFeatureConnection;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.LightItem;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JinglePlayer;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public final class HangingLightsConnection
extends HangingFeatureConnection<Light<?>> {
    private static final int MAX_LIGHT = 15;
    private static final int LIGHT_UPDATE_WAIT = 400;
    private static final int LIGHT_UPDATE_RATE = 10;
    private StringType string;
    private List<ItemStack> pattern;
    private JinglePlayer jinglePlayer = new JinglePlayer();
    private boolean wasPlaying = false;
    private boolean isOn = true;
    private long lastToggleTick = -1L;
    private final Set<BlockPos> litBlocks = new HashSet<BlockPos>();
    private final Set<BlockPos> oldLitBlocks = new HashSet<BlockPos>();
    private int lightUpdateTime = (int)(Math.random() * 400.0 / 2.0);
    private int lightUpdateIndex;

    public HangingLightsConnection(ConnectionType<? extends HangingLightsConnection> type, Level world, Fastener<?> fastenerOrigin, UUID uuid) {
        super(type, world, fastenerOrigin, uuid);
        this.string = (StringType)StringTypes.BLACK_STRING.get();
        this.pattern = new ArrayList<ItemStack>();
    }

    public StringType getString() {
        return this.string;
    }

    @Nullable
    public Jingle getPlayingJingle() {
        return this.jinglePlayer.getJingle();
    }

    public void play(Jingle jingle, int lightOffset) {
        this.jinglePlayer.play(jingle, lightOffset);
    }

    @Override
    public boolean interact(Player player, Vec3 hit, FeatureType featureType, int feature, ItemStack heldStack, InteractionHand hand) {
        BlockFastener blockFastener;
        BlockEntity be;
        Fastener pos2;
        float pitch;
        SoundEvent lightSnd;
        boolean isLightItem = heldStack.getItem() instanceof LightItem;
        boolean isInLightsTag = heldStack.is(FLCraftingRecipes.LIGHTS);
        if (featureType == FEATURE && (isLightItem || isInLightsTag)) {
            int totalFeatures = ((Light[])this.features).length;
            while (this.pattern.size() < totalFeatures) {
                int targetIndex = this.pattern.size();
                ItemStack currentLight = ItemStack.EMPTY;
                if (targetIndex < ((Light[])this.features).length) {
                    currentLight = ((Light[])this.features)[targetIndex].getItem();
                }
                this.pattern.add(currentLight.isEmpty() ? ItemStack.EMPTY : currentLight.copy());
            }
            while (this.pattern.size() <= feature) {
                this.pattern.add(ItemStack.EMPTY);
            }
            int index = feature;
            ItemStack light = this.pattern.get(index);
            if (!ItemStack.matches((ItemStack)light, (ItemStack)heldStack)) {
                ItemStack placed = heldStack.split(1);
                this.pattern.set(index, placed);
                if (!light.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)light);
                }
                this.computeCatenary();
                this.fastener.setDirty();
                this.getDestination().get(this.world, false).ifPresent(Fastener::setDirty);
                this.world.playSound(null, hit.x, hit.y, hit.z, (SoundEvent)FLSounds.FEATURE_COLOR_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        if (super.interact(player, hit, featureType, feature, heldStack, hand)) {
            return true;
        }
        if (!heldStack.isEmpty()) {
            return false;
        }
        long currentTick = this.world.getGameTime();
        if (currentTick == this.lastToggleTick) {
            LogUtils.getLogger().info("FL_DEBUG: Ignoring duplicate toggle on same tick");
            return true;
        }
        this.lastToggleTick = currentTick;
        boolean wasOn = this.isOn;
        this.isOn = !this.isOn;
        LogUtils.getLogger().info("FL_DEBUG: Toggling lights - wasOn=" + wasOn + " isOn=" + this.isOn);
        if (this.isOn) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.world.playSound(null, hit.x, hit.y, hit.z, lightSnd, SoundSource.BLOCKS, 1.0f, pitch);
        boolean on = !this.isDynamic() && this.isOn;
        LogUtils.getLogger().info("FL_DEBUG: Setting power state - on=" + on + " isDynamic=" + this.isDynamic() + " features.length=" + ((Light[])this.features).length);
        for (Light light : (Light[])this.features) {
            light.power(on, true);
        }
        if (!on) {
            for (BlockPos pos2 : this.litBlocks) {
                this.removeLight(pos2);
            }
            this.litBlocks.clear();
        }
        this.fastener.setDirty();
        this.getDestination().get(this.world, false).ifPresent(Fastener::setDirty);
        if (!this.world.isClientSide() && (pos2 = this.fastener) instanceof BlockFastener && (be = this.world.getBlockEntity((BlockPos)(pos2 = (blockFastener = (BlockFastener)pos2).getPos()))) instanceof FastenerBlockEntity) {
            FastenerBlockEntity fastenerBE = (FastenerBlockEntity)be;
            fastenerBE.setChanged();
            BlockState state = this.world.getBlockState((BlockPos)pos2);
            this.world.sendBlockUpdated((BlockPos)pos2, state, state, 3);
        }
        return true;
    }

    @Override
    public void onUpdate() {
        this.jinglePlayer.tick(this.world, this.fastener.getConnectionPoint(), (Light[])this.features, this.world.isClientSide());
        boolean playing = this.jinglePlayer.isPlaying();
        if (playing || this.wasPlaying) {
            this.updateNeighbors(this.fastener);
            this.getDestination().get(this.world, false).ifPresent(this::updateNeighbors);
        }
        this.wasPlaying = playing;
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.tick(this.world, this.fastener.getConnectionPoint());
        }
        if (on && ((Light[])this.features).length > 0) {
            ++this.lightUpdateTime;
            if (this.lightUpdateTime > 400 && this.lightUpdateTime % 10 == 0) {
                if (this.lightUpdateIndex >= ((Light[])this.features).length) {
                    this.lightUpdateIndex = 0;
                    this.lightUpdateTime = this.world.random.nextInt(200);
                } else {
                    this.setLight(BlockPos.containing((Position)((Light[])this.features)[this.lightUpdateIndex++].getAbsolutePoint(this.fastener)));
                }
            }
        }
    }

    private void updateNeighbors(Fastener<?> fastener) {
        this.world.updateNeighbourForOutputSignal(fastener.getPos(), (Block)FLBlocks.FASTENER.get());
    }

    protected Light<?>[] createFeatures(int length) {
        return new Light[length];
    }

    @Override
    protected boolean canReuse(Light<?> feature, int index) {
        return ItemStack.matches((ItemStack)feature.getItem(), (ItemStack)this.getPatternStack(index));
    }

    @Override
    protected Light<?> createFeature(int index, Vec3 point, float yaw, float pitch) {
        ItemStack lightData = this.getPatternStack(index);
        return this.createLight(index, point, yaw, pitch, lightData, LightVariant.get(lightData).orElse(SimpleLightVariant.FAIRY_LIGHT));
    }

    private ItemStack getPatternStack(int index) {
        if (this.pattern.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (index < this.pattern.size()) {
            return this.pattern.get(index);
        }
        return this.pattern.get(index % this.pattern.size());
    }

    @Override
    protected void updateFeature(Light<?> light) {
        super.updateFeature(light);
        if (!this.isDynamic() && this.isOn) {
            BlockPos pos = BlockPos.containing((Position)light.getAbsolutePoint(this.fastener));
            this.litBlocks.add(pos);
            this.setLight(pos);
        }
    }

    private <T extends LightBehavior> Light<T> createLight(int index, Vec3 point, float yaw, float pitch, ItemStack stack, LightVariant<T> variant) {
        return new Light<T>(index, point, yaw, pitch, stack, variant, 0.125f);
    }

    @Override
    protected float getFeatureSpacing() {
        if (this.pattern.isEmpty()) {
            return SimpleLightVariant.FAIRY_LIGHT.getSpacing();
        }
        float spacing = 0.0f;
        for (ItemStack patternLightData : this.pattern) {
            float lightSpacing = LightVariant.get(patternLightData).orElse(SimpleLightVariant.FAIRY_LIGHT).getSpacing();
            if (!(lightSpacing > spacing)) continue;
            spacing = lightSpacing;
        }
        return spacing;
    }

    @Override
    protected void onBeforeUpdateFeatures() {
        this.oldLitBlocks.clear();
        this.oldLitBlocks.addAll(this.litBlocks);
        this.litBlocks.clear();
    }

    @Override
    protected void onAfterUpdateFeatures() {
        if (!this.world.isClientSide()) {
            boolean on = !this.isDynamic() && this.isOn;
            LogUtils.getLogger().info("FL_DEBUG: onAfterUpdateFeatures (SERVER) - isOn=" + this.isOn + " on=" + on + " features.length=" + ((Light[])this.features).length);
            for (Light light : (Light[])this.features) {
                light.power(on, true);
            }
        } else {
            LogUtils.getLogger().info("FL_DEBUG: onAfterUpdateFeatures (CLIENT) - skipping power state update, will be set via deserialize() - isOn=" + this.isOn + " features.length=" + ((Light[])this.features).length);
        }
        this.oldLitBlocks.removeAll(this.litBlocks);
        Iterator<BlockPos> oldIter = this.oldLitBlocks.iterator();
        while (oldIter.hasNext()) {
            this.removeLight(oldIter.next());
            oldIter.remove();
        }
    }

    @Override
    public void onRemove() {
        for (BlockPos pos : this.litBlocks) {
            this.removeLight(pos);
        }
    }

    private void removeLight(BlockPos pos) {
        if (this.world.getBlockState(pos).is(Blocks.LIGHT)) {
            this.world.removeBlock(pos, false);
        }
    }

    private void setLight(BlockPos pos) {
        if (this.world.isLoaded(pos) && this.world.isEmptyBlock(pos) && this.world.getBrightness(LightLayer.BLOCK, pos) < 15) {
            this.world.setBlock(pos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)), 2);
        }
    }

    public boolean canCurrentlyPlayAJingle() {
        return !this.jinglePlayer.isPlaying();
    }

    public float getJingleProgress() {
        return this.jinglePlayer.getProgress();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = super.serialize();
        compound.put("jinglePlayer", (Tag)this.jinglePlayer.serialize());
        LogUtils.getLogger().info("FL_DEBUG: serialize (" + (this.world.isClientSide() ? "CLIENT" : "SERVER") + ") - isOn=" + this.isOn);
        compound.putBoolean("isOn", this.isOn);
        ListTag litBlocks = new ListTag();
        for (BlockPos litBlock : this.litBlocks) {
            litBlocks.add((Object)NbtUtils.writeBlockPos((BlockPos)litBlock));
        }
        compound.put("litBlocks", (Tag)litBlocks);
        return compound;
    }

    @Override
    public void deserialize(CompoundTag compound) {
        throw new UnsupportedOperationException("Use deserialize(CompoundTag, HolderLookup.Provider)");
    }

    @Override
    public void deserialize(CompoundTag compound, HolderLookup.Provider provider) {
        boolean newIsOn;
        LogUtils.getLogger().info("FL_DEBUG: deserialize(CompoundTag, Provider) ENTRY - world=" + (this.world != null ? (this.world.isClientSide() ? "CLIENT" : "SERVER") : "NULL") + " isOn=" + this.isOn + " compound.hasIsOn=" + compound.contains("isOn"));
        super.deserialize(compound, provider);
        if (this.jinglePlayer == null) {
            this.jinglePlayer = new JinglePlayer();
        }
        if (!this.jinglePlayer.isPlaying() && compound.contains("jinglePlayer")) {
            this.jinglePlayer.deserialize(compound.getCompound("jinglePlayer"));
        }
        boolean oldIsOn = this.isOn;
        boolean hasIsOn = compound.contains("isOn");
        this.isOn = newIsOn = hasIsOn ? compound.getBoolean("isOn") : this.isOn;
        LogUtils.getLogger().info("FL_DEBUG: deserialize (" + (this.world != null && this.world.isClientSide() ? "CLIENT" : "SERVER") + ") - hasIsOn=" + hasIsOn + " oldIsOn=" + oldIsOn + " newIsOn=" + newIsOn + " isOn=" + this.isOn + " features.length=" + (this.features != null ? ((Light[])this.features).length : 0));
        if (this.world != null && this.world.isClientSide() && this.features != null) {
            boolean on = !this.isDynamic() && this.isOn;
            LogUtils.getLogger().info("FL_DEBUG: deserialize (CLIENT) - updating power state - on=" + on + " isDynamic=" + this.isDynamic() + " features.length=" + ((Light[])this.features).length);
            for (Light light : (Light[])this.features) {
                light.power(on, true);
            }
            if (!on) {
                for (BlockPos pos2 : this.litBlocks) {
                    this.removeLight(pos2);
                }
                this.litBlocks.clear();
            }
        }
        this.litBlocks.clear();
        if (compound.contains("litBlocks", 9)) {
            ListTag litBlocks = compound.getList("litBlocks", 10);
            for (int i = 0; i < litBlocks.size(); ++i) {
                CompoundTag blockPosTag = litBlocks.getCompound(i);
                NbtUtils.readBlockPos((CompoundTag)blockPosTag, (String)"Pos").ifPresent(pos -> this.litBlocks.add((BlockPos)pos));
            }
        }
        if (this.world != null && this.world.isClientSide() && !this.isOn) {
            for (BlockPos pos3 : this.litBlocks) {
                this.removeLight(pos3);
            }
            this.litBlocks.clear();
        }
    }

    @Override
    public CompoundTag serializeLogic() {
        CompoundTag compound = super.serializeLogic();
        HangingLightsConnectionItem.setString(compound, this.string);
        ListTag tagList = new ListTag();
        for (ItemStack light : this.pattern) {
            Tag savedTag = light.save((HolderLookup.Provider)this.world.registryAccess());
            if (savedTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)savedTag;
                int color = DyeableItem.getColor(light);
                compoundTag.putInt("fl_backup_color", color);
            }
            tagList.add((Object)savedTag);
        }
        compound.put("pattern", (Tag)tagList);
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundTag compound, HolderLookup.Provider provider) {
        super.deserializeLogic(compound, provider);
        this.string = HangingLightsConnectionItem.getString(compound);
        ListTag patternList = compound.getList("pattern", 10);
        this.pattern = new ArrayList<ItemStack>();
        for (int i = 0; i < patternList.size(); ++i) {
            CompoundTag lightCompound = patternList.getCompound(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)lightCompound).orElse(ItemStack.EMPTY);
            if (lightCompound.contains("fl_backup_color", 99)) {
                int color = lightCompound.getInt("fl_backup_color");
                DyeableItem.setColor(stack, color);
            }
            this.pattern.add(stack);
        }
        this.computeCatenary();
    }
}

