/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.connection.SymbolSet;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.Letter;
import me.paulf.fairylights.server.net.clientbound.OpenEditLetteredConnectionScreenMessage;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LetterBuntingConnection
extends Connection
implements Lettered {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SymbolSet SYMBOLS = new SymbolSet.Builder(7, "0-9, A-Z, &, !, ?").add(" 0123456789ABCDEFGHJKLMNOPQRSTUVWXYZ&?", 6).add("I", 4).add("!", 2).build();
    private static final float TRACKING = 0.0625f;
    private static final StylingPresence SUPPORTED_STYLING = new StylingPresence(true, false, false, false, false, false);
    private StyledString text;
    private Letter[] letters = new Letter[0];

    public LetterBuntingConnection(ConnectionType<? extends LetterBuntingConnection> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
        this.text = new StyledString();
    }

    @Override
    public float getRadius() {
        return 0.028125f;
    }

    public Letter[] getLetters() {
        return this.letters;
    }

    @Override
    public void processClientAction(Player player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public void onConnect(Level world, Player user, ItemStack heldStack) {
        if (this.text.isEmpty() && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, new OpenEditLetteredConnectionScreenMessage<LetterBuntingConnection>(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void onUpdate() {
        for (Letter letter : this.letters) {
            letter.tick(this.world);
        }
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateLetters();
    }

    private void updateLetters() {
        if (this.text.isEmpty()) {
            this.letters = new Letter[0];
        } else {
            Curve catenary = this.getCatenary();
            float textWidth = 0.0f;
            int textLen = 0;
            float[] pointOffsets = new float[this.text.length()];
            float catLength = catenary.getLength();
            for (int i = 0; i < this.text.length(); ++i) {
                float w = SYMBOLS.getWidth(this.text.charAt(i));
                pointOffsets[i] = textWidth + w / 2.0f;
                if ((textWidth += w + 0.0625f) > catLength) break;
                ++textLen;
            }
            float offset = catLength / 2.0f - textWidth / 2.0f;
            int i = 0;
            while (i < textLen) {
                int n = i++;
                pointOffsets[n] = pointOffsets[n] + offset;
            }
            int pointIdx = 0;
            Letter[] prevLetters = this.letters;
            ArrayList<Letter> letters = new ArrayList<Letter>(this.text.length());
            Curve.SegmentIterator it = catenary.iterator();
            float distance = 0.0f;
            while (it.next()) {
                float pointOffset;
                float length = it.getLength();
                for (int n = pointIdx; n < textLen && (pointOffset = pointOffsets[n]) < distance + length; ++n) {
                    Letter letter;
                    float t = (pointOffset - distance) / length;
                    Vec3 point = new Vec3((double)it.getX(t), (double)it.getY(t), (double)it.getZ(t));
                    if (prevLetters != null && pointIdx < prevLetters.length) {
                        letter = prevLetters[pointIdx];
                        letter.set(point, it.getYaw(), it.getPitch());
                        letter.set(this.text.charAt(pointIdx), this.text.styleAt(pointIdx));
                    } else {
                        letter = new Letter(pointIdx, point, it.getYaw(), it.getPitch(), SYMBOLS, this.text.charAt(pointIdx), this.text.styleAt(pointIdx));
                    }
                    letters.add(letter);
                    ++pointIdx;
                }
                if (pointIdx == textLen) break;
                distance += length;
            }
            this.letters = letters.toArray(new Letter[0]);
        }
    }

    @Override
    public StylingPresence getSupportedStyling() {
        return SUPPORTED_STYLING;
    }

    @Override
    public boolean isSupportedCharacter(int chr) {
        return SYMBOLS.contains(chr);
    }

    @Override
    public boolean isSupportedText(StyledString text) {
        float len = 0.0f;
        float available = this.getCatenary().getLength();
        for (int i = 0; i < text.length(); ++i) {
            float w = SYMBOLS.getWidth(text.charAt(i));
            if ((len += w + 0.0625f) > available) {
                return false;
            }
            if (text.styleAt(i).isPlain()) continue;
            return false;
        }
        return Lettered.super.isSupportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        LOGGER.info("LetterBuntingConnection: setText called with '{}'", (Object)text);
        this.computeCatenary();
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    public Function<String, String> getInputTransformer() {
        return str -> Normalizer.normalize(str, Normalizer.Form.NFKD).replaceAll("[\\p{Mn}\\p{Sk}]", "").toUpperCase(Locale.ROOT);
    }

    @Override
    public String getAllowedDescription() {
        return SYMBOLS.getDescription();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createTextGUI() {
        return new EditLetteredConnectionScreen<LetterBuntingConnection>(this);
    }

    @Override
    public CompoundTag serializeLogic() {
        CompoundTag compound = super.serializeLogic();
        compound.put("text", (Tag)StyledString.serialize(this.text));
        LOGGER.info("LetterBuntingConnection: serializeLogic text='{}' tag={}", (Object)this.text, (Object)compound);
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundTag compound, HolderLookup.Provider provider) {
        super.deserializeLogic(compound, provider);
        this.text = StyledString.deserialize(compound.getCompound("text"));
    }
}

