/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.function.Function;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;

public interface Lettered {
    default public StylingPresence getSupportedStyling() {
        return StylingPresence.ALL;
    }

    default public boolean isSupportedCharacter(int chr) {
        return Character.isValidCodePoint(chr) && (0x8000040 >> Character.getType(chr) & 1) == 0;
    }

    default public boolean isSupportedText(StyledString text) {
        for (int i = 0; i < text.length(); ++i) {
            if (this.isSupportedCharacter(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setText(StyledString var1);

    public StyledString getText();

    default public String getAllowedDescription() {
        return "";
    }

    default public Function<String, String> getInputTransformer() {
        return Function.identity();
    }

    public Screen createTextGUI();

    default public boolean openTextGui(Player player, PlayerAction action, Intersection intersection) {
        if (action == PlayerAction.INTERACT && player.isSecondaryUseActive()) {
            Minecraft.getInstance().setScreen(this.createTextGUI());
            return false;
        }
        return true;
    }
}

