/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.creativetabs;

import java.util.ArrayList;
import java.util.Collection;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class FairyLightsItemGroup {
    public static final DeferredRegister<CreativeModeTab> TAB_REG = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"fairylights");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GENERAL = TAB_REG.register("general", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 1).icon(() -> new ItemStack((ItemLike)FLItems.HANGING_LIGHTS.get())).title((Component)Component.literal((String)"FairyLights")).displayItems((config, output) -> {
        for (DyeColor color : DyeColor.values()) {
            ItemStack hangingLights = FLCraftingRecipes.makeHangingLights(new ItemStack((ItemLike)FLItems.HANGING_LIGHTS.get()), color);
            DyeableItem.setColor(hangingLights, color);
            output.accept(hangingLights);
        }
        for (DyeColor color : DyeColor.values()) {
            ItemStack stack = new ItemStack((ItemLike)FLItems.PENNANT_BUNTING.get());
            DyeableItem.setColor(stack, color);
            output.accept(FLCraftingRecipes.makePennant(stack, color));
        }
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.TINSEL.get()));
        ItemStack bunting = new ItemStack((ItemLike)FLItems.LETTER_BUNTING.get(), 1);
        output.accept(bunting);
        output.accept(new ItemStack((ItemLike)FLItems.GARLAND.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.TRIANGLE_PENNANT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SPEARHEAD_PENNANT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SWALLOWTAIL_PENNANT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SQUARE_PENNANT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.FAIRY_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.PAPER_LANTERN.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.ORB_LANTERN.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.FLOWER_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.CANDLE_LANTERN_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.OIL_LANTERN_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.JACK_O_LANTERN.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SKULL_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.GHOST_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SPIDER_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.WITCH_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.SNOWFLAKE_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.HEART_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.MOON_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.STAR_LIGHT.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.ICICLE_LIGHTS.get()));
        output.acceptAll(FairyLightsItemGroup.generateCollection((Item)FLItems.METEOR_LIGHT.get()));
        output.accept(new ItemStack((ItemLike)FLItems.OIL_LANTERN.get()));
        output.accept(new ItemStack((ItemLike)FLItems.CANDLE_LANTERN.get()));
        output.accept(new ItemStack((ItemLike)FLItems.INCANDESCENT_LIGHT.get()));
    }).build());

    private static Collection<ItemStack> generateCollection(@NotNull Item item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (DyeColor color : DyeColor.values()) {
            stacks.add(DyeableItem.setColor(new ItemStack((ItemLike)item), color));
        }
        return stacks;
    }
}

